/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.convert;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Factory;
import com.owlike.genson.Genson;
import com.owlike.genson.TransformationException;
import com.owlike.genson.TransformationRuntimeException;
import com.owlike.genson.annotation.HandleClassMetadata;
import com.owlike.genson.annotation.HandleNull;
import com.owlike.genson.annotation.WithoutBeanView;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import com.owlike.genson.stream.ValueType;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class DefaultConverters {

    public static class CalendarConverter
    implements Converter<Calendar> {
        private final DateConverter dateConverter;

        CalendarConverter(DateConverter dateConverter) {
            this.dateConverter = dateConverter;
        }

        @Override
        public void serialize(Calendar object, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            this.dateConverter.serialize(object.getTime(), writer, ctx);
        }

        @Override
        public Calendar deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            GregorianCalendar cal = null;
            if (ValueType.NULL != reader.getValueType()) {
                cal = new GregorianCalendar();
                cal.setTime(this.dateConverter.deserialize(reader, ctx));
            }
            return cal;
        }
    }

    public static final class CalendarConverterFactory
    implements Factory<Converter<Calendar>> {
        private final CalendarConverter calendarConverter;

        public CalendarConverterFactory(DateConverter dateConverter) {
            this.calendarConverter = new CalendarConverter(dateConverter);
        }

        @Override
        public Converter<Calendar> create(Type type, Genson genson) {
            if (!Calendar.class.isAssignableFrom(TypeUtil.getRawClass(type))) {
                throw new IllegalStateException("CalendarConverterFactory create method can be called only for Calendar type and subtypes.");
            }
            return this.calendarConverter;
        }
    }

    public static class UUIDConverter
    implements Converter<UUID> {
        public static final UUIDConverter instance = new UUIDConverter();

        private UUIDConverter() {
        }

        @Override
        public void serialize(UUID object, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.writeValue(object.toString());
        }

        @Override
        public UUID deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            return UUID.fromString(reader.valueAsString());
        }
    }

    @HandleClassMetadata
    @WithoutBeanView
    public static class TimestampConverter
    implements Converter<Timestamp> {
        public static final TimestampConverter instance = new TimestampConverter();

        private TimestampConverter() {
        }

        @Override
        public Timestamp deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            return Timestamp.valueOf(reader.valueAsString());
        }

        @Override
        public void serialize(Timestamp object, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.writeValue(object.toString());
        }
    }

    @HandleClassMetadata
    @WithoutBeanView
    public static class BigIntegerConverter
    implements Converter<BigInteger> {
        public static final BigIntegerConverter instance = new BigIntegerConverter();

        private BigIntegerConverter() {
        }

        @Override
        public BigInteger deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            return new BigInteger(reader.valueAsString());
        }

        @Override
        public void serialize(BigInteger object, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.writeValue(object);
        }
    }

    @HandleClassMetadata
    @WithoutBeanView
    public static class BigDecimalConverter
    implements Converter<BigDecimal> {
        public static final BigDecimalConverter instance = new BigDecimalConverter();

        private BigDecimalConverter() {
        }

        @Override
        public BigDecimal deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            return new BigDecimal(reader.valueAsString());
        }

        @Override
        public void serialize(BigDecimal object, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.writeValue(object);
        }
    }

    @HandleClassMetadata
    @WithoutBeanView
    public static class URIConverter
    implements Converter<URI> {
        public static final URIConverter instance = new URIConverter();

        private URIConverter() {
        }

        @Override
        public void serialize(URI object, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.writeUnsafeValue(object.toString());
        }

        @Override
        public URI deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            return URI.create(reader.valueAsString());
        }
    }

    @HandleClassMetadata
    @WithoutBeanView
    public static class URLConverter
    implements Converter<URL> {
        public static final URLConverter instance = new URLConverter();

        private URLConverter() {
        }

        @Override
        public URL deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            return new URL(reader.valueAsString());
        }

        @Override
        public void serialize(URL object, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.writeValue(object.toExternalForm());
        }
    }

    public static final class EnumConverterFactory
    implements Factory<Converter<? extends Enum<?>>> {
        public static final EnumConverterFactory instance = new EnumConverterFactory();

        private EnumConverterFactory() {
        }

        @Override
        public Converter<Enum<?>> create(Type type, Genson genson) {
            Class<?> rawClass = TypeUtil.getRawClass(type);
            return rawClass.isEnum() || Enum.class.isAssignableFrom(rawClass) ? new EnumConverter(rawClass) : null;
        }
    }

    @HandleClassMetadata
    @WithoutBeanView
    public static class EnumConverter<T extends Enum<T>>
    implements Converter<T> {
        private final Class<T> eClass;

        public EnumConverter(Class<T> eClass) {
            this.eClass = eClass;
        }

        @Override
        public void serialize(T obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.writeUnsafeValue(((Enum)obj).name());
        }

        @Override
        public T deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            return Enum.valueOf(this.eClass, reader.valueAsString());
        }
    }

    public static final class UntypedConverterFactory
    implements Factory<Converter<Object>> {
        public static final UntypedConverterFactory instance = new UntypedConverterFactory();

        private UntypedConverterFactory() {
        }

        @Override
        public Converter<Object> create(Type type, Genson genson) {
            if (TypeUtil.match(type, Object.class, true)) {
                return UntypedConverter.instance;
            }
            return null;
        }

        private static final class UntypedConverter
        implements Converter<Object> {
            static final UntypedConverter instance = new UntypedConverter();

            private UntypedConverter() {
            }

            @Override
            public Object deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
                return ctx.genson.deserialize(reader.getValueType().toClass(), reader, ctx);
            }

            @Override
            public void serialize(Object obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
                if (Object.class.equals(obj.getClass())) {
                    throw new UnsupportedOperationException("Serialization of type Object is not supported by default serializers.");
                }
                ctx.genson.serialize(obj, obj.getClass(), writer, ctx);
            }
        }
    }

    @HandleClassMetadata
    @WithoutBeanView
    public static class DateConverter
    implements Converter<Date> {
        private DateFormat dateFormat;
        private final boolean asTimeInMillis;

        public DateConverter() {
            this(SimpleDateFormat.getDateInstance(), false);
        }

        public DateConverter(DateFormat dateFormat, boolean asTimeInMillis) {
            if (dateFormat == null) {
                dateFormat = SimpleDateFormat.getDateInstance();
            }
            this.dateFormat = dateFormat;
            this.asTimeInMillis = asTimeInMillis;
        }

        @Override
        public void serialize(Date obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            if (this.asTimeInMillis) {
                writer.writeValue(obj.getTime());
            } else {
                writer.writeUnsafeValue(this.format(obj));
            }
        }

        protected synchronized String format(Date date) {
            return this.dateFormat.format(date);
        }

        @Override
        public Date deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            try {
                if (this.asTimeInMillis) {
                    return new Date(reader.valueAsLong());
                }
                return this.read(reader.valueAsString());
            }
            catch (ParseException e) {
                throw new TransformationException("Could not parse date " + reader.valueAsString(), e);
            }
        }

        protected synchronized Date read(String dateString) throws ParseException {
            return this.dateFormat.parse(dateString);
        }
    }

    public static final class MapConverterFactory
    implements Factory<Converter<Map<?, ?>>> {
        public static final MapConverterFactory instance = new MapConverterFactory();

        private MapConverterFactory() {
        }

        @Override
        public Converter<Map<?, ?>> create(Type type, Genson genson) {
            return new MapConverter(TypeUtil.getRawClass(type), genson.provideConverter(TypeUtil.typeOf(1, type)));
        }
    }

    @HandleClassMetadata
    public static class MapConverter<V>
    implements Converter<Map<String, V>> {
        private final Class<V> vClass;
        private final Converter<V> valueConverter;

        public MapConverter(Class<V> vClass, Converter<V> valueConverter) {
            this.vClass = vClass;
            this.valueConverter = valueConverter;
        }

        @Override
        public Map<String, V> deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            reader.beginObject();
            HashMap<String, V> map = new HashMap<String, V>();
            while (reader.hasNext()) {
                reader.next();
                String name = reader.name();
                V e = this.valueConverter.deserialize(reader, ctx);
                map.put(name, e);
            }
            reader.endObject();
            return map;
        }

        @Override
        public void serialize(Map<String, V> obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.beginObject();
            for (Map.Entry<String, V> entry : obj.entrySet()) {
                writer.writeName(entry.getKey());
                V value = entry.getValue();
                if (value != null) {
                    if (this.vClass.isInstance(value)) {
                        this.valueConverter.serialize(value, writer, ctx);
                        continue;
                    }
                    this.valueConverter.serialize(value, writer, ctx);
                    continue;
                }
                writer.writeNull();
            }
            writer.endObject();
        }
    }

    public static final class PrimitiveConverterFactory
    implements Factory<Converter<?>> {
        public static final PrimitiveConverterFactory instance = new PrimitiveConverterFactory();

        private PrimitiveConverterFactory() {
        }

        @Override
        public Converter<?> create(Type type, Genson genson) {
            Class<?> rawClass = TypeUtil.getRawClass(type);
            if (rawClass.isPrimitive()) {
                if (rawClass.equals(Boolean.TYPE)) {
                    return booleanConverter.instance;
                }
                if (rawClass.equals(Integer.TYPE)) {
                    return intConverter.instance;
                }
                if (rawClass.equals(Double.TYPE)) {
                    return doubleConverter.instance;
                }
                if (rawClass.equals(Long.TYPE)) {
                    return longConverter.instance;
                }
            }
            return null;
        }

        @HandleClassMetadata
        @HandleNull
        @WithoutBeanView
        public static final class longConverter
        implements Converter<Long> {
            public static final longConverter instance = new longConverter();

            private longConverter() {
            }

            @Override
            public void serialize(Long obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
                writer.writeValue(obj);
            }

            @Override
            public Long deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
                return ValueType.NULL.equals((Object)reader.getValueType()) ? 0L : reader.valueAsLong();
            }
        }

        @HandleClassMetadata
        @HandleNull
        @WithoutBeanView
        public static final class doubleConverter
        implements Converter<Double> {
            public static final doubleConverter instance = new doubleConverter();

            private doubleConverter() {
            }

            @Override
            public void serialize(Double obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
                writer.writeValue(obj);
            }

            @Override
            public Double deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
                return ValueType.NULL.equals((Object)reader.getValueType()) ? 0.0 : reader.valueAsDouble();
            }
        }

        @HandleClassMetadata
        @HandleNull
        @WithoutBeanView
        public static final class intConverter
        implements Converter<Integer> {
            public static final intConverter instance = new intConverter();

            private intConverter() {
            }

            @Override
            public void serialize(Integer obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
                writer.writeValue(obj);
            }

            @Override
            public Integer deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
                return ValueType.NULL.equals((Object)reader.getValueType()) ? 0 : reader.valueAsInt();
            }
        }

        @HandleClassMetadata
        @HandleNull
        @WithoutBeanView
        public static final class booleanConverter
        implements Converter<Boolean> {
            public static final booleanConverter instance = new booleanConverter();

            private booleanConverter() {
            }

            @Override
            public void serialize(Boolean obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
                writer.writeValue(obj);
            }

            @Override
            public Boolean deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
                return ValueType.NULL.equals((Object)reader.getValueType()) ? false : reader.valueAsBoolean();
            }
        }
    }

    @HandleClassMetadata
    @WithoutBeanView
    public static final class NumberConverter
    implements Converter<Number> {
        public static final NumberConverter instance = new NumberConverter();

        private NumberConverter() {
        }

        @Override
        public Number deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            ValueType vt = reader.getValueType();
            if (ValueType.INTEGER.equals((Object)vt)) {
                return reader.valueAsInt();
            }
            if (ValueType.DOUBLE.equals((Object)vt)) {
                return reader.valueAsDouble();
            }
            String value = reader.valueAsString();
            return "".equals(value) ? (Number)null : (Number)this.parse(value, vt);
        }

        @Override
        public void serialize(Number obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.writeValue(obj);
        }

        private Number parse(String value, ValueType valueType) {
            try {
                if (value.indexOf(46) >= 0) {
                    return Double.parseDouble(value);
                }
                long longValue = Long.parseLong(value);
                if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
                    return (int)longValue;
                }
                return Long.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                throw new TransformationRuntimeException("Could not convert input value " + value + " of type " + valueType.toClass() + " to a Number type.", nfe);
            }
        }
    }

    @HandleClassMetadata
    @WithoutBeanView
    public static final class DoubleConverter
    implements Converter<Double> {
        public static final DoubleConverter instance = new DoubleConverter();

        private DoubleConverter() {
        }

        @Override
        public Double deserialize(ObjectReader reader, Context ctx) throws NumberFormatException, IOException {
            if (ValueType.STRING.equals((Object)reader.getValueType())) {
                String value = reader.valueAsString();
                return "".equals(value) ? null : Double.valueOf(value);
            }
            return reader.valueAsDouble();
        }

        @Override
        public void serialize(Double obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.writeValue(obj);
        }
    }

    @HandleClassMetadata
    @WithoutBeanView
    public static final class LongConverter
    implements Converter<Long> {
        public static final LongConverter instance = new LongConverter();

        private LongConverter() {
        }

        @Override
        public Long deserialize(ObjectReader reader, Context ctx) throws NumberFormatException, IOException {
            if (ValueType.STRING.equals((Object)reader.getValueType())) {
                String value = reader.valueAsString();
                return "".equals(value) ? null : Long.valueOf(value);
            }
            return reader.valueAsLong();
        }

        @Override
        public void serialize(Long obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.writeValue(obj);
        }
    }

    @HandleClassMetadata
    @WithoutBeanView
    public static final class IntegerConverter
    implements Converter<Integer> {
        public static final IntegerConverter instance = new IntegerConverter();

        private IntegerConverter() {
        }

        @Override
        public void serialize(Integer obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.writeValue(obj);
        }

        @Override
        public Integer deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            if (ValueType.STRING.equals((Object)reader.getValueType())) {
                String value = reader.valueAsString();
                return "".equals(value) ? null : Integer.valueOf(value);
            }
            return reader.valueAsInt();
        }
    }

    @HandleClassMetadata
    @WithoutBeanView
    public static final class BooleanConverter
    implements Converter<Boolean> {
        public static final BooleanConverter instance = new BooleanConverter();

        private BooleanConverter() {
        }

        @Override
        public void serialize(Boolean obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.writeValue(obj);
        }

        @Override
        public Boolean deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            if (ValueType.STRING.equals((Object)reader.getValueType())) {
                String value = reader.valueAsString();
                return "".equals(value) ? null : Boolean.valueOf(value);
            }
            return reader.valueAsBoolean();
        }
    }

    @HandleClassMetadata
    @WithoutBeanView
    public static final class StringConverter
    implements Converter<String> {
        public static final StringConverter instance = new StringConverter();

        private StringConverter() {
        }

        @Override
        public void serialize(String value, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.writeValue(value);
        }

        @Override
        public String deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            return reader.valueAsString();
        }
    }

    public static final class ArrayConverterFactory
    implements Factory<Converter<Object>> {
        public static final ArrayConverterFactory instance = new ArrayConverterFactory();

        private ArrayConverterFactory() {
        }

        @Override
        public Converter<Object> create(Type forType, Genson genson) {
            if (forType instanceof GenericArrayType || forType instanceof Class && ((Class)forType).isArray()) {
                Converter elementConverter = genson.provideConverter(TypeUtil.getCollectionType(forType));
                return new ArrayConverter(TypeUtil.getRawClass(TypeUtil.getCollectionType(forType)), elementConverter);
            }
            return null;
        }
    }

    @HandleClassMetadata
    public static class ArrayConverter<E>
    implements Converter<Object> {
        private final Class<E> eClass;
        private final Converter<E> elementConverter;

        public ArrayConverter(Class<E> eClass, Converter<E> elementConverter) {
            this.eClass = eClass;
            this.elementConverter = elementConverter;
        }

        @Override
        public void serialize(Object array, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.beginArray();
            int len = Array.getLength(array);
            for (int i = 0; i < len; ++i) {
                Object e = Array.get(array, i);
                this.elementConverter.serialize(e, writer, ctx);
            }
            writer.endArray();
        }

        @Override
        public Object deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            reader.beginArray();
            int size = 10;
            Object array = Array.newInstance(this.eClass, size);
            int idx = 0;
            while (reader.hasNext()) {
                reader.next();
                if (idx >= size) {
                    size = size * 2 + 1;
                    array = this.expandArray(array, idx, size);
                }
                Array.set(array, idx++, this.elementConverter.deserialize(reader, ctx));
            }
            reader.endArray();
            if (idx < size) {
                array = this.expandArray(array, idx, idx);
            }
            return array;
        }

        private Object expandArray(Object array, int len, int size) {
            Object tmpArray = Array.newInstance(this.eClass, size);
            System.arraycopy(array, 0, tmpArray, 0, len);
            return tmpArray;
        }
    }

    public static final class CollectionConverterFactory
    implements Factory<Converter<Collection<?>>> {
        public static final CollectionConverterFactory instance = new CollectionConverterFactory();

        private CollectionConverterFactory() {
        }

        @Override
        public Converter<Collection<?>> create(Type forType, Genson genson) {
            Converter elementConverter = genson.provideConverter(TypeUtil.getCollectionType(forType));
            Class<?> parameterRawClass = TypeUtil.getRawClass(TypeUtil.getCollectionType(forType));
            if (Set.class.isAssignableFrom(TypeUtil.getRawClass(forType))) {
                return new SetConverter(parameterRawClass, elementConverter);
            }
            return new CollectionConverter(parameterRawClass, elementConverter);
        }
    }

    @HandleClassMetadata
    public static class CollectionConverter<E>
    implements Converter<Collection<E>> {
        private final Class<E> eClass;
        private final Converter<E> elementConverter;

        public CollectionConverter(Class<E> eClass, Converter<E> elementConverter) {
            this.eClass = eClass;
            this.elementConverter = elementConverter;
        }

        @Override
        public Collection<E> deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            reader.beginArray();
            Collection<E> col = this.create();
            while (reader.hasNext()) {
                reader.next();
                E e = this.elementConverter.deserialize(reader, ctx);
                col.add(e);
            }
            reader.endArray();
            return col;
        }

        @Override
        public void serialize(Collection<E> array, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            writer.beginArray();
            for (E e : array) {
                this.elementConverter.serialize(e, writer, ctx);
            }
            writer.endArray();
        }

        public Converter<E> getElementConverter() {
            return this.elementConverter;
        }

        protected Collection<E> create() {
            return new ArrayList();
        }
    }

    @HandleClassMetadata
    public static class SetConverter<E>
    extends CollectionConverter<E> {
        public SetConverter(Class<E> eClass, Converter<E> elementConverter) {
            super(eClass, elementConverter);
        }

        @Override
        protected Collection<E> create() {
            return new HashSet();
        }
    }
}

