/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.Converter;
import com.owlike.genson.Factory;
import com.owlike.genson.Genson;
import com.owlike.genson.ThreadLocalHolder;
import com.owlike.genson.convert.ContextualFactory;
import com.owlike.genson.reflect.BeanCreator;
import com.owlike.genson.reflect.BeanDescriptor;
import com.owlike.genson.reflect.BeanDescriptorProvider;
import com.owlike.genson.reflect.BeanProperty;
import com.owlike.genson.reflect.PropertyAccessor;
import com.owlike.genson.reflect.PropertyMutator;
import com.owlike.genson.reflect.TypeUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractBeanDescriptorProvider
implements BeanDescriptorProvider {
    static final String CONTEXT_KEY = "__GENSON$CREATION_CONTEXT";
    static final String DO_NOT_CACHE_CONVERTER_KEY = "__GENOSN$DO_NOT_CACHE_CONVERTER";
    private final ContextualConverterFactory contextualConverterFactory;

    protected AbstractBeanDescriptorProvider(ContextualConverterFactory contextualConverterFactory) {
        this.contextualConverterFactory = contextualConverterFactory;
    }

    @Override
    public <T> BeanDescriptor<T> provide(Class<T> ofClass, Genson genson) {
        return this.provide(ofClass, ofClass, genson);
    }

    @Override
    public BeanDescriptor<?> provide(Type ofType, Genson genson) {
        return this.provide(TypeUtil.getRawClass(ofType), ofType, genson);
    }

    @Override
    public <T> BeanDescriptor<T> provide(Class<T> ofClass, Type ofType, Genson genson) {
        BeanDescriptor<T> descriptor;
        LinkedHashMap<String, LinkedList<PropertyMutator>> mutatorsMap = new LinkedHashMap<String, LinkedList<PropertyMutator>>();
        LinkedHashMap<String, LinkedList<PropertyAccessor>> accessorsMap = new LinkedHashMap<String, LinkedList<PropertyAccessor>>();
        List<BeanCreator> creators = this.provideBeanCreators(ofType, genson);
        this.provideBeanPropertyAccessors(ofType, accessorsMap, genson);
        this.provideBeanPropertyMutators(ofType, mutatorsMap, genson);
        ArrayList<PropertyAccessor> accessors = new ArrayList<PropertyAccessor>(accessorsMap.size());
        for (Map.Entry entry : accessorsMap.entrySet()) {
            PropertyAccessor accessor = this.checkAndMergeAccessors((String)entry.getKey(), (LinkedList)entry.getValue());
            if (accessor == null) continue;
            accessors.add(accessor);
        }
        HashMap<String, PropertyMutator> mutators = new HashMap<String, PropertyMutator>(mutatorsMap.size());
        for (Map.Entry entry : mutatorsMap.entrySet()) {
            PropertyMutator propertyMutator = this.checkAndMergeMutators((String)entry.getKey(), (LinkedList)entry.getValue());
            if (propertyMutator == null) continue;
            mutators.put(propertyMutator.name, propertyMutator);
        }
        this.mergeMutatorsWithCreatorProperties(ofType, mutators, creators);
        BeanCreator ctr = this.checkAndMerge(ofType, creators);
        for (PropertyAccessor propertyAccessor : accessors) {
            propertyAccessor.propertySerializer = this.provide(propertyAccessor, genson);
        }
        for (PropertyMutator propertyMutator : mutators.values()) {
            propertyMutator.propertyDeserializer = this.provide(propertyMutator, genson);
        }
        if (ctr != null) {
            for (BeanCreator.BeanCreatorProperty beanCreatorProperty : ctr.parameters.values()) {
                beanCreatorProperty.propertyDeserializer = this.provide(beanCreatorProperty, genson);
            }
        }
        if (!ofClass.isAssignableFrom((descriptor = this.create(ofClass, ofType, ctr, accessors, mutators)).getOfClass())) {
            throw new ClassCastException("Actual implementation of BeanDescriptorProvider " + this.getClass() + " seems to do something wrong. Expected BeanDescriptor for type " + ofClass + " but provided BeanDescriptor for type " + descriptor.getOfClass());
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Converter<Object> provide(BeanProperty property, Genson genson) {
        Converter<?> converter = this.contextualConverterFactory.provide(property, genson);
        if (converter != null) {
            ThreadLocalHolder.store(DO_NOT_CACHE_CONVERTER_KEY, true);
            ThreadLocalHolder.store(CONTEXT_KEY, converter);
        }
        try {
            Converter<Object> converter2 = genson.provideConverter(property.type);
            return converter2;
        }
        finally {
            if (converter != null) {
                ThreadLocalHolder.remove(DO_NOT_CACHE_CONVERTER_KEY, Boolean.class);
                ThreadLocalHolder.remove(CONTEXT_KEY, Converter.class);
            }
        }
    }

    protected <T> BeanDescriptor<T> create(Class<T> forClass, Type ofType, BeanCreator creator, List<PropertyAccessor> accessors, Map<String, PropertyMutator> mutators) {
        return new BeanDescriptor<T>(forClass, TypeUtil.getRawClass(ofType), accessors, mutators, creator);
    }

    protected abstract List<BeanCreator> provideBeanCreators(Type var1, Genson var2);

    protected abstract void provideBeanPropertyMutators(Type var1, Map<String, LinkedList<PropertyMutator>> var2, Genson var3);

    protected abstract void provideBeanPropertyAccessors(Type var1, Map<String, LinkedList<PropertyAccessor>> var2, Genson var3);

    protected abstract BeanCreator checkAndMerge(Type var1, List<BeanCreator> var2);

    protected abstract PropertyMutator checkAndMergeMutators(String var1, LinkedList<PropertyMutator> var2);

    protected abstract void mergeMutatorsWithCreatorProperties(Type var1, Map<String, PropertyMutator> var2, List<BeanCreator> var3);

    protected abstract PropertyAccessor checkAndMergeAccessors(String var1, LinkedList<PropertyAccessor> var2);

    public static final class ContextualFactoryDecorator
    implements Factory<Converter<?>> {
        private final Factory<Converter<?>> delegatedConverter;

        public ContextualFactoryDecorator(Factory<Converter<?>> delegatedConverter) {
            this.delegatedConverter = delegatedConverter;
        }

        @Override
        public Converter<?> create(Type type, Genson genson) {
            Converter converter = ThreadLocalHolder.get(AbstractBeanDescriptorProvider.CONTEXT_KEY, Converter.class);
            if (converter != null) {
                return converter;
            }
            return this.delegatedConverter.create(type, genson);
        }
    }

    public static final class ContextualConverterFactory {
        private final List<? extends ContextualFactory<?>> contextualFactories;

        public ContextualConverterFactory(List<? extends ContextualFactory<?>> contextualFactories) {
            this.contextualFactories = contextualFactories != null ? new ArrayList(contextualFactories) : new ArrayList();
        }

        Converter<?> provide(BeanProperty property, Genson genson) {
            Class<?> type = property.getType();
            for (ContextualFactory<?> factory : this.contextualFactories) {
                Converter<?> object = null;
                Type factoryType = TypeUtil.lookupGenericType(ContextualFactory.class, factory.getClass());
                factoryType = TypeUtil.expandType(factoryType, factory.getClass());
                Type factoryParameter = TypeUtil.typeOf(0, factoryType);
                if (type instanceof Class && ((Class)type).isPrimitive()) {
                    type = TypeUtil.wrap(type);
                }
                if (!TypeUtil.match(type, factoryParameter, false) || (object = factory.create(property, genson)) == null) continue;
                return object;
            }
            return null;
        }
    }
}

