/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.reflect.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public abstract class BeanProperty {
    protected final String name;
    protected final Type type;
    protected final Class<?> declaringClass;
    protected final Annotation[] annotations;

    protected BeanProperty(String name, Type type, Class<?> declaringClass, Annotation[] annotations) {
        this.name = name;
        this.type = type;
        this.declaringClass = declaringClass;
        this.annotations = annotations;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getRawClass() {
        return TypeUtil.getRawClass(this.type);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Annotation ann : this.annotations) {
            if (!annotationClass.isInstance(ann)) continue;
            return (T)((Annotation)annotationClass.cast(ann));
        }
        return null;
    }

    abstract int priority();

    abstract String signature();
}

