/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.stream;

import com.owlike.genson.stream.Base64;
import com.owlike.genson.stream.JsonStreamException;
import com.owlike.genson.stream.JsonType;
import com.owlike.genson.stream.ObjectWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class JsonWriter
implements ObjectWriter {
    private static final char[][] REPLACEMENT_CHARS;
    private static final char[][] HTML_SAFE_REPLACEMENT_CHARS;
    private static final char[] _INT_TO_CHARARRAY;
    private static final char[] NULL_VALUE;
    private static final char[] TRUE_VALUE;
    private static final char[] FALSE_VALUE;
    private static final int _LIMIT_WRITE_TO_BUFFER = 64;
    private final boolean htmlSafe;
    private final boolean skipNull;
    private final Writer writer;
    final Deque<JsonType> _ctx = new ArrayDeque<JsonType>(10);
    private boolean _hasPrevious;
    private String _name;
    private final boolean indentation;
    private static final char[] _indentation;
    private final char[] _buffer = new char[1024];
    private final int _bufferSize = this._buffer.length;
    private int _len = 0;
    List<MetadataPair> _metadata = new ArrayList<MetadataPair>();

    public JsonWriter(Writer writer) {
        this(writer, false, false, false);
    }

    public JsonWriter(Writer writer, boolean skipNull, boolean htmlSafe, boolean indentation) {
        this.writer = writer;
        this.skipNull = skipNull;
        this.htmlSafe = htmlSafe;
        this.indentation = indentation;
        this._ctx.push(JsonType.EMPTY);
    }

    @Override
    public void close() {
        this.flush();
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new JsonStreamException(e);
        }
    }

    @Override
    public void flush() {
        this.flushBuffer();
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new JsonStreamException(e);
        }
    }

    @Override
    public JsonWriter beginArray() {
        this.clearMetadata();
        if (this._ctx.peek() == JsonType.OBJECT && this._name == null) {
            throw new JsonStreamException("Englobing scope is OBJECT before begining a new value call writeName.");
        }
        return this.begin(JsonType.ARRAY, '[');
    }

    @Override
    public JsonWriter beginObject() {
        if (this._ctx.peek() == JsonType.METADATA) {
            this._ctx.pop();
            this.begin(JsonType.OBJECT, '{');
            for (MetadataPair pair : this._metadata) {
                this.writeName('@' + pair.name).writeInternalString(pair.value);
            }
        } else {
            this.begin(JsonType.OBJECT, '{');
        }
        return this;
    }

    protected final JsonWriter begin(JsonType jsonType, char token) {
        this.beforeValue();
        this._ctx.push(jsonType);
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = token;
        this._hasPrevious = false;
        return this;
    }

    @Override
    public JsonWriter endArray() {
        return this.end(JsonType.ARRAY, ']');
    }

    @Override
    public JsonWriter endObject() {
        return this.end(JsonType.OBJECT, '}');
    }

    private final JsonWriter end(JsonType jsonType, char token) {
        JsonType jt = this._ctx.pop();
        if (jt != jsonType) {
            throw new JsonStreamException("Expect type " + jsonType.name() + " but was written " + jt.name() + ", you must call the adequate beginXXX method before endXXX.");
        }
        if (this.indentation) {
            this._buffer[this._len++] = 10;
            for (int i = 0; i < this._ctx.size() - 1; ++i) {
                this.writeToBuffer(_indentation, 0, 2);
            }
        }
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = token;
        this._hasPrevious = true;
        return this;
    }

    private final JsonWriter beforeValue() {
        JsonType enclosingType = this._ctx.peek();
        if (enclosingType == JsonType.ARRAY) {
            if (this._name != null) {
                throw this.newIllegalKeyValuePairInJsonArray(this._name);
            }
            if (this._hasPrevious) {
                if (this._len + 1 >= this._bufferSize) {
                    this.flushBuffer();
                }
                this._buffer[this._len++] = 44;
            }
            this.indent();
        } else if (this._name != null) {
            int l = this._name.length();
            if (this._len + 4 + l >= this._bufferSize) {
                this.flushBuffer();
            }
            if (this._hasPrevious) {
                this._buffer[this._len++] = 44;
            }
            this.indent();
            if (this._len + 3 + l >= this._bufferSize) {
                this.flushBuffer();
            }
            this._buffer[this._len++] = 34;
            this.writeToBuffer(this._name, 0, l);
            this._buffer[this._len++] = 34;
            this._buffer[this._len++] = 58;
            this._name = null;
        } else if (enclosingType == JsonType.OBJECT) {
            throw this.newIllegalSingleValueInJsonObject();
        }
        return this;
    }

    private JsonStreamException newIllegalKeyValuePairInJsonArray(String name) {
        return JsonStreamException.niceTrace(new JsonStreamException("Tried to write key/value pair with key=" + name + ", Json format does not allow key/value pairs inside arrays, only allowed for Json Objects."));
    }

    private JsonStreamException newIllegalSingleValueInJsonObject() {
        return JsonStreamException.niceTrace(new JsonStreamException("Tried to write value with no key in a JsonObject, Json format does not allow values without keys in JsonObjects, authorized only for arrays."));
    }

    private final void clearMetadata() {
        if (this._ctx.peek() == JsonType.METADATA) {
            this._metadata.clear();
            this._ctx.pop();
        }
    }

    protected void indent() {
        if (this.indentation) {
            if (this._len + 1 >= this._bufferSize) {
                this.flushBuffer();
            }
            if (this._ctx.peek() != JsonType.EMPTY) {
                this._buffer[this._len++] = 10;
            }
            int len = this._ctx.peek() == JsonType.METADATA ? this._ctx.size() - 2 : this._ctx.size() - 1;
            for (int i = 0; i < len; ++i) {
                this.writeToBuffer(_indentation, 0, 2);
            }
        }
    }

    @Override
    public JsonWriter writeName(String name) {
        this._name = name;
        return this;
    }

    @Override
    public JsonWriter writeValue(int value) {
        this.clearMetadata();
        this.beforeValue();
        if (this._len + 11 >= this._bufferSize) {
            this.flushBuffer();
        }
        if (value < 0) {
            this._buffer[this._len++] = 45;
            this.writeInt(-((long)value));
        } else {
            this.writeInt(value);
        }
        this._hasPrevious = true;
        return this;
    }

    @Override
    public JsonWriter writeValue(double value) {
        this.checkValidJsonDouble(value);
        this.clearMetadata();
        this.beforeValue();
        this.writeToBuffer(Double.toString(value), 0);
        this._hasPrevious = true;
        return this;
    }

    @Override
    public JsonWriter writeValue(long value) {
        this.clearMetadata();
        this.beforeValue();
        if (this._len + 21 >= this._bufferSize) {
            this.flushBuffer();
        }
        if (value < 0L) {
            if (value != Long.MIN_VALUE) {
                this._buffer[this._len++] = 45;
                this.writeInt(-1L * value);
            } else {
                this.writeToBuffer(Long.toString(value), 0);
            }
        } else {
            this.writeInt(value);
        }
        this._hasPrevious = true;
        return this;
    }

    @Override
    public ObjectWriter writeValue(short value) {
        this.clearMetadata();
        this.beforeValue();
        if (this._len + 5 >= this._bufferSize) {
            this.flushBuffer();
        }
        if (value < 0) {
            this._buffer[this._len++] = 45;
            value = (short)(value * -1);
        }
        this.writeInt(value);
        this._hasPrevious = true;
        return this;
    }

    @Override
    public ObjectWriter writeValue(float value) {
        this.checkValidJsonFloat(Float.valueOf(value));
        this.clearMetadata();
        this.beforeValue();
        this.writeToBuffer(Float.toString(value), 0);
        this._hasPrevious = true;
        return this;
    }

    @Override
    public JsonWriter writeValue(boolean value) {
        this.clearMetadata();
        this.beforeValue();
        if (value) {
            this.writeToBuffer(TRUE_VALUE, 0, 4);
        } else {
            this.writeToBuffer(FALSE_VALUE, 0, 5);
        }
        this._hasPrevious = true;
        return this;
    }

    protected final int writeInt(long value) {
        int len = (int)Math.log10(value) + 1;
        if (value == 0L) {
            this._buffer[this._len++] = 48;
            return 1;
        }
        int pos = this._len + len - 1;
        while (value > 0L) {
            long intPart = value / 10L;
            this._buffer[pos--] = _INT_TO_CHARARRAY[(int)(value - intPart * 10L)];
            value = intPart;
        }
        this._len += len;
        return len;
    }

    @Override
    public JsonWriter writeValue(Number value) {
        this.checkValidJsonDouble(value);
        this.checkValidJsonFloat(value);
        this.clearMetadata();
        this.beforeValue();
        this.writeToBuffer(value.toString(), 0);
        this._hasPrevious = true;
        return this;
    }

    private void checkValidJsonDouble(Number num) {
        if (num.equals(Double.NaN)) {
            throw new NumberFormatException("NaN is not a valid json number.");
        }
        if (num.equals(Double.NEGATIVE_INFINITY) || num.equals(Double.POSITIVE_INFINITY)) {
            throw new NumberFormatException("Infinity is not a valid json number.");
        }
    }

    private void checkValidJsonFloat(Number num) {
        if (num.equals(Float.valueOf(Float.NaN))) {
            throw new NumberFormatException("NaN is not a valid json number.");
        }
        if (num.equals(Float.valueOf(Float.NEGATIVE_INFINITY)) || num.equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
            throw new NumberFormatException("Infinity is not a valid json number.");
        }
    }

    @Override
    public ObjectWriter writeValue(byte[] value) {
        this.clearMetadata();
        this.beforeValue();
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = 34;
        char[] charArray = Base64.encodeToChar(value, false);
        this.writeToBuffer(charArray, 0, charArray.length);
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = 34;
        this._hasPrevious = true;
        this.flush();
        return this;
    }

    @Override
    public JsonWriter writeUnsafeValue(String value) {
        this.clearMetadata();
        this.beforeValue();
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = 34;
        this.writeToBuffer(value.toCharArray(), 0, value.length());
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = 34;
        this._hasPrevious = true;
        return this;
    }

    @Override
    public JsonWriter writeValue(String value) {
        this.clearMetadata();
        this.writeInternalString(value);
        return this;
    }

    private final void writeInternalString(String value) {
        char[][] replacements;
        this.beforeValue();
        char[][] cArray = replacements = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = 34;
        int last = 0;
        int length = value.length();
        char[] carray = value.toCharArray();
        for (int i = 0; i < length; ++i) {
            char[] replacement;
            char c = carray[i];
            if (c < '\u0080') {
                replacement = replacements[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028".toCharArray();
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029".toCharArray();
            }
            if (last < i) {
                this.writeToBuffer(carray, last, i - last);
            }
            this.writeToBuffer(replacement, 0, replacement.length);
            last = i + 1;
        }
        if (last < length) {
            this.writeToBuffer(carray, last, length - last);
        }
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = 34;
        this._hasPrevious = true;
    }

    @Override
    public ObjectWriter writeNull() {
        if (this.skipNull) {
            this._name = null;
        } else {
            this.beforeValue();
            this.writeToBuffer(NULL_VALUE, 0, 4);
            this._hasPrevious = true;
        }
        return this;
    }

    @Override
    public ObjectWriter beginNextObjectMetadata() {
        if (this._ctx.peek() != JsonType.METADATA) {
            this._ctx.push(JsonType.METADATA);
            this._metadata.clear();
        }
        return this;
    }

    @Override
    public ObjectWriter writeMetadata(String name, String value) {
        if (this._ctx.peek() == JsonType.METADATA) {
            this._metadata.add(new MetadataPair(name, value));
        } else if (this._ctx.peek() == JsonType.OBJECT) {
            this.writeName('@' + name);
            this.writeValue(value);
        }
        return this;
    }

    private final void writeToBuffer(char[] data, int offset, int length) {
        if (length < 64 && length < this._bufferSize - this._len) {
            System.arraycopy(data, offset, this._buffer, this._len, length);
            this._len += length;
        } else {
            this.flushBuffer();
            try {
                this.writer.write(data, offset, length);
            }
            catch (IOException e) {
                throw new JsonStreamException(e);
            }
        }
    }

    private final void writeToBuffer(String data, int offset) {
        this.writeToBuffer(data, offset, data.length());
    }

    private final void writeToBuffer(String data, int offset, int length) {
        if (length < 64 && length < this._bufferSize - this._len) {
            data.getChars(offset, offset + length, this._buffer, this._len);
            this._len += length;
        } else {
            this.flushBuffer();
            try {
                this.writer.write(data, offset, length);
            }
            catch (IOException e) {
                throw new JsonStreamException(e);
            }
        }
    }

    private final void flushBuffer() {
        try {
            if (this._len > 0) {
                this.writer.write(this._buffer, 0, this._len);
                this._len = 0;
            }
        }
        catch (IOException ioe) {
            throw new JsonStreamException(ioe);
        }
    }

    public Writer unwrap() {
        return this.writer;
    }

    static {
        int i;
        REPLACEMENT_CHARS = new char[128][];
        for (i = 0; i <= 31; ++i) {
            JsonWriter.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i).toCharArray();
        }
        JsonWriter.REPLACEMENT_CHARS[34] = "\\\"".toCharArray();
        JsonWriter.REPLACEMENT_CHARS[92] = "\\\\".toCharArray();
        JsonWriter.REPLACEMENT_CHARS[9] = "\\t".toCharArray();
        JsonWriter.REPLACEMENT_CHARS[8] = "\\b".toCharArray();
        JsonWriter.REPLACEMENT_CHARS[10] = "\\n".toCharArray();
        JsonWriter.REPLACEMENT_CHARS[13] = "\\r".toCharArray();
        JsonWriter.REPLACEMENT_CHARS[12] = "\\f".toCharArray();
        HTML_SAFE_REPLACEMENT_CHARS = (char[][])REPLACEMENT_CHARS.clone();
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027".toCharArray();
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[60] = "\\u003c".toCharArray();
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e".toCharArray();
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026".toCharArray();
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d".toCharArray();
        _INT_TO_CHARARRAY = new char[10];
        for (i = 0; i < 10; ++i) {
            JsonWriter._INT_TO_CHARARRAY[i] = (char)(i + 48);
        }
        NULL_VALUE = new char[]{'n', 'u', 'l', 'l'};
        TRUE_VALUE = new char[]{'t', 'r', 'u', 'e'};
        FALSE_VALUE = new char[]{'f', 'a', 'l', 's', 'e'};
        _indentation = new char[]{' ', ' '};
    }

    private class MetadataPair {
        final String name;
        final String value;

        public MetadataPair(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

