/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.JsonBindingException;
import com.owlike.genson.reflect.BeanCreator;
import com.owlike.genson.reflect.BeanProperty;
import com.owlike.genson.reflect.PropertyAccessor;
import com.owlike.genson.reflect.PropertyMutator;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class BeanDescriptor<T>
implements Converter<T> {
    final Class<?> fromDeclaringClass;
    final Class<T> ofClass;
    final Map<String, PropertyMutator> mutableProperties;
    final List<PropertyAccessor> accessibleProperties;
    final BeanCreator creator;
    private final boolean _noArgCtr;
    private static final Comparator<BeanProperty> _readablePropsComparator = new Comparator<BeanProperty>(){

        @Override
        public int compare(BeanProperty o1, BeanProperty o2) {
            return o1.name.compareToIgnoreCase(o2.name);
        }
    };

    public BeanDescriptor(Class<T> forClass, Class<?> fromDeclaringClass, List<PropertyAccessor> readableBps, Map<String, PropertyMutator> writableBps, BeanCreator creator) {
        this.ofClass = forClass;
        this.fromDeclaringClass = fromDeclaringClass;
        this.creator = creator;
        this.mutableProperties = writableBps;
        Collections.sort(readableBps, _readablePropsComparator);
        this.accessibleProperties = Collections.unmodifiableList(readableBps);
        this._noArgCtr = this.creator != null ? this.creator.parameters.size() == 0 : false;
    }

    public boolean isReadable() {
        return !this.accessibleProperties.isEmpty();
    }

    public boolean isWritable() {
        return this.creator != null;
    }

    @Override
    public void serialize(T obj, ObjectWriter writer, Context ctx) {
        writer.beginObject();
        for (PropertyAccessor accessor : this.accessibleProperties) {
            accessor.serialize(obj, writer, ctx);
        }
        writer.endObject();
    }

    @Override
    public T deserialize(ObjectReader reader, Context ctx) {
        T bean = null;
        if (this._noArgCtr) {
            bean = this.ofClass.cast(this.creator.create(new Object[0]));
            this.deserialize(bean, reader, ctx);
        } else {
            if (this.creator == null) {
                throw new JsonBindingException("No constructor has been found for type " + this.ofClass);
            }
            bean = this._deserWithCtrArgs(reader, ctx);
        }
        return bean;
    }

    public void deserialize(T into, ObjectReader reader, Context ctx) {
        reader.beginObject();
        while (reader.hasNext()) {
            reader.next();
            String propName = reader.name();
            PropertyMutator mutator = this.mutableProperties.get(propName);
            if (mutator != null) {
                mutator.deserialize(into, reader, ctx);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    protected T _deserWithCtrArgs(ObjectReader reader, Context ctx) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        reader.beginObject();
        while (reader.hasNext()) {
            reader.next();
            String propName = reader.name();
            PropertyMutator muta = this.mutableProperties.get(propName);
            if (muta != null) {
                Object param = muta.deserialize(reader, ctx);
                names.add(propName);
                values.add(param);
                continue;
            }
            reader.skipValue();
        }
        int size = names.size();
        int settersToCallCnt = size - this.creator.parameters.size();
        if (settersToCallCnt < 0) {
            settersToCallCnt = 0;
        }
        Object[] creatorArgs = new Object[this.creator.parameters.size()];
        String[] newNames = new String[size];
        Object[] newValues = new Object[size];
        int j = 0;
        for (int i = 0; i < size; ++i) {
            BeanCreator.BeanCreatorProperty mp = this.creator.parameters.get(names.get(i));
            if (mp != null) {
                creatorArgs[mp.index] = values.get(i);
                continue;
            }
            newNames[j] = (String)names.get(i);
            newValues[j] = values.get(i);
            ++j;
        }
        T bean = this.ofClass.cast(this.creator.create(creatorArgs));
        for (int i = 0; i < size; ++i) {
            PropertyMutator property = this.mutableProperties.get(newNames[i]);
            if (property == null) continue;
            property.mutate(bean, newValues[i]);
        }
        reader.endObject();
        return bean;
    }

    public Class<T> getOfClass() {
        return this.ofClass;
    }
}

