/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.Genson;
import com.owlike.genson.reflect.BeanDescriptor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public interface BeanDescriptorProvider {
    public BeanDescriptor<?> provide(Type var1, Genson var2);

    public <T> BeanDescriptor<T> provide(Class<T> var1, Genson var2);

    public <T> BeanDescriptor<T> provide(Class<T> var1, Type var2, Genson var3);

    public static class CompositeBeanDescriptorProvider
    implements BeanDescriptorProvider {
        private final List<BeanDescriptorProvider> providers;

        public CompositeBeanDescriptorProvider(List<BeanDescriptorProvider> providers) {
            this.providers = new ArrayList<BeanDescriptorProvider>(providers);
        }

        @Override
        public BeanDescriptor<?> provide(Type ofType, Genson genson) {
            BeanDescriptorProvider provider;
            BeanDescriptor<?> desc = null;
            Iterator<BeanDescriptorProvider> i$ = this.providers.iterator();
            while (i$.hasNext() && (desc = (provider = i$.next()).provide(ofType, genson)) == null) {
            }
            return desc;
        }

        @Override
        public <T> BeanDescriptor<T> provide(Class<T> ofClass, Genson genson) {
            BeanDescriptorProvider provider;
            BeanDescriptor<T> desc = null;
            Iterator<BeanDescriptorProvider> i$ = this.providers.iterator();
            while (i$.hasNext() && (desc = (provider = i$.next()).provide(ofClass, genson)) == null) {
            }
            return desc;
        }

        @Override
        public <T> BeanDescriptor<T> provide(Class<T> ofClass, Type type, Genson genson) {
            BeanDescriptorProvider provider;
            BeanDescriptor<T> desc = null;
            Iterator<BeanDescriptorProvider> i$ = this.providers.iterator();
            while (i$.hasNext() && (desc = (provider = i$.next()).provide(ofClass, type, genson)) == null) {
            }
            return desc;
        }
    }
}

