/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson;

import com.owlike.genson.BeanView;
import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Factory;
import com.owlike.genson.GenericType;
import com.owlike.genson.GensonBuilder;
import com.owlike.genson.JsonBindingException;
import com.owlike.genson.ThreadLocalHolder;
import com.owlike.genson.reflect.BeanDescriptor;
import com.owlike.genson.reflect.BeanDescriptorProvider;
import com.owlike.genson.stream.JsonReader;
import com.owlike.genson.stream.JsonWriter;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Genson {
    private static final Genson _default = new GensonBuilder().create();
    private final ConcurrentHashMap<Type, Converter<?>> converterCache = new ConcurrentHashMap();
    private final Factory<Converter<?>> converterFactory;
    private final BeanDescriptorProvider beanDescriptorFactory;
    private final Converter<Object> nullConverter;
    private final Map<Class<?>, String> classAliasMap;
    private final Map<String, Class<?>> aliasClassMap;
    private final boolean skipNull;
    private final boolean htmlSafe;
    private final boolean withClassMetadata;
    private final boolean withMetadata;
    private final boolean strictDoubleParse;
    private final boolean indent;
    private final boolean failOnMissingProperty;
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public Genson() {
        this(Genson._default.converterFactory, Genson._default.beanDescriptorFactory, Genson._default.nullConverter, Genson._default.skipNull, Genson._default.htmlSafe, Genson._default.aliasClassMap, Genson._default.withClassMetadata, Genson._default.strictDoubleParse, Genson._default.indent, Genson._default.withMetadata, Genson._default.failOnMissingProperty);
    }

    public Genson(Factory<Converter<?>> converterFactory, BeanDescriptorProvider beanDescProvider, Converter<Object> nullConverter, boolean skipNull, boolean htmlSafe, Map<String, Class<?>> classAliases, boolean withClassMetadata, boolean strictDoubleParse, boolean indent, boolean withMetadata, boolean failOnMissingProperty) {
        this.converterFactory = converterFactory;
        this.beanDescriptorFactory = beanDescProvider;
        this.nullConverter = nullConverter;
        this.skipNull = skipNull;
        this.htmlSafe = htmlSafe;
        this.aliasClassMap = classAliases;
        this.withClassMetadata = withClassMetadata;
        this.classAliasMap = new HashMap(classAliases.size());
        for (Map.Entry<String, Class<?>> entry : classAliases.entrySet()) {
            this.classAliasMap.put(entry.getValue(), entry.getKey());
        }
        this.strictDoubleParse = strictDoubleParse;
        this.indent = indent;
        this.withMetadata = withClassMetadata || withMetadata;
        this.failOnMissingProperty = failOnMissingProperty;
    }

    public <T> Converter<T> provideConverter(Type forType) {
        if (Boolean.TRUE.equals(ThreadLocalHolder.get("__GENSON$DO_NOT_CACHE_CONVERTER", Boolean.class))) {
            return this.converterFactory.create(forType, this);
        }
        Converter<?> converter = this.converterCache.get(forType);
        if (converter == null) {
            converter = this.converterFactory.create(forType, this);
            if (converter == null) {
                throw new JsonBindingException("No converter found for type " + forType);
            }
            this.converterCache.putIfAbsent(forType, converter);
        }
        return converter;
    }

    public String serialize(Object object) {
        StringWriter sw = new StringWriter();
        ObjectWriter writer = this.createWriter(sw);
        if (object == null) {
            this.serializeNull(writer);
        } else {
            this.serialize(object, object.getClass(), writer, new Context(this));
        }
        return sw.toString();
    }

    public String serialize(Object object, GenericType<?> type) {
        StringWriter sw = new StringWriter();
        ObjectWriter writer = this.createWriter(sw);
        if (object == null) {
            this.serializeNull(writer);
        } else {
            this.serialize(object, type.getType(), writer, new Context(this));
        }
        return sw.toString();
    }

    public String serialize(Object object, Class<? extends BeanView<?>> firstView, Class<? extends BeanView<?>> ... withViews) {
        StringWriter sw = new StringWriter();
        ObjectWriter writer = this.createWriter(sw);
        ArrayList views = new ArrayList(withViews.length);
        for (Class<? extends BeanView<?>> view : withViews) {
            views.add(view);
        }
        views.add(firstView);
        if (object == null) {
            this.serializeNull(writer);
        } else {
            this.serialize(object, object.getClass(), writer, new Context(this, views));
        }
        return sw.toString();
    }

    public void serialize(Object object, Writer writer) {
        ObjectWriter objectWriter = this.createWriter(writer);
        if (object == null) {
            this.serializeNull(objectWriter);
        } else {
            this.serialize(object, object.getClass(), objectWriter, new Context(this));
        }
    }

    public void serialize(Object object, OutputStream output) {
        ObjectWriter objectWriter = this.createWriter(output);
        if (object == null) {
            this.serializeNull(objectWriter);
        } else {
            this.serialize(object, object.getClass(), objectWriter, new Context(this));
        }
    }

    public byte[] serializeBytes(Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectWriter objectWriter = this.createWriter(baos);
        if (object == null) {
            this.serializeNull(objectWriter);
        } else {
            this.serialize(object, object.getClass(), objectWriter, new Context(this));
        }
        return baos.toByteArray();
    }

    public void serialize(Object object, ObjectWriter writer, Context ctx) {
        if (object == null) {
            this.serializeNull(writer);
        } else {
            this.serialize(object, object.getClass(), writer, ctx);
        }
    }

    public void serialize(Object object, Type type, ObjectWriter writer, Context ctx) {
        Converter<Object> ser = this.provideConverter(type);
        try {
            ser.serialize(object, writer, ctx);
            writer.flush();
        }
        catch (Exception e) {
            throw new JsonBindingException("Failed to serialize object of type " + type, e);
        }
    }

    private void serializeNull(ObjectWriter writer) {
        try {
            this.nullConverter.serialize(null, writer, null);
            writer.flush();
        }
        catch (Exception e) {
            throw new JsonBindingException("Could not serialize null value.", e);
        }
    }

    public <T> T deserialize(String fromSource, Class<T> toClass) {
        return this.deserialize(GenericType.of(toClass), this.createReader(new StringReader(fromSource)), new Context(this));
    }

    public <T> T deserialize(String fromSource, GenericType<T> toType) {
        return this.deserialize(toType, this.createReader(new StringReader(fromSource)), new Context(this));
    }

    public <T> T deserialize(Reader reader, GenericType<T> toType) {
        return this.deserialize(toType, this.createReader(reader), new Context(this));
    }

    public <T> T deserialize(Reader reader, Class<T> toType) {
        return this.deserialize(GenericType.of(toType), this.createReader(reader), new Context(this));
    }

    public <T> T deserialize(InputStream input, Class<T> toType) {
        return this.deserialize(GenericType.of(toType), this.createReader(input), new Context(this));
    }

    public <T> T deserialize(InputStream input, GenericType<T> toType) {
        return this.deserialize(toType, this.createReader(input), new Context(this));
    }

    public <T> T deserialize(byte[] input, Class<T> toType) {
        return this.deserialize(GenericType.of(toType), this.createReader(input), new Context(this));
    }

    public <T> T deserialize(byte[] input, GenericType<T> toType) {
        return this.deserialize(toType, this.createReader(input), new Context(this));
    }

    public <T> T deserialize(String fromSource, GenericType<T> toType, Class<? extends BeanView<?>> ... withViews) {
        StringReader reader = new StringReader(fromSource);
        return this.deserialize(toType, this.createReader(reader), new Context(this, Arrays.asList(withViews)));
    }

    public <T> T deserialize(String fromSource, Class<T> toType, Class<? extends BeanView<?>> ... withViews) {
        StringReader reader = new StringReader(fromSource);
        return this.deserialize(GenericType.of(toType), this.createReader(reader), new Context(this, Arrays.asList(withViews)));
    }

    public <T> T deserialize(GenericType<T> type, Reader reader, Class<? extends BeanView<?>> ... withViews) {
        return this.deserialize(type, this.createReader(reader), new Context(this, Arrays.asList(withViews)));
    }

    public <T> T deserialize(GenericType<T> type, ObjectReader reader, Context ctx) {
        Converter<T> deser = this.provideConverter(type.getType());
        try {
            return deser.deserialize(reader, ctx);
        }
        catch (Exception e) {
            throw new JsonBindingException("Could not deserialize to type " + type.getRawClass(), e);
        }
    }

    public <T> T deserializeInto(String json, T object) {
        return this.deserializeInto(this.createReader(new StringReader(json)), object, new Context(this));
    }

    public <T> T deserializeInto(byte[] jsonBytes, T object) {
        return this.deserializeInto(this.createReader(jsonBytes), object, new Context(this));
    }

    public <T> T deserializeInto(InputStream is, T object) {
        return this.deserializeInto(this.createReader(is), object, new Context(this));
    }

    public <T> T deserializeInto(Reader reader, T object) {
        return this.deserializeInto(this.createReader(reader), object, new Context(this));
    }

    public <T> T deserializeInto(ObjectReader reader, T object, Context ctx) {
        BeanDescriptor<?> bd = this.getBeanDescriptorProvider().provide(object.getClass(), this);
        bd.deserialize(object, reader, ctx);
        return object;
    }

    public <T> String aliasFor(Class<T> clazz) {
        String alias = this.classAliasMap.get(clazz);
        if (alias == null) {
            alias = clazz.getName();
            this.classAliasMap.put(clazz, alias);
        }
        return alias;
    }

    public Class<?> classFor(String alias) throws ClassNotFoundException {
        Class<?> clazz = this.aliasClassMap.get(alias);
        if (clazz == null) {
            clazz = Class.forName(alias);
            this.aliasClassMap.put(alias, clazz);
        }
        return clazz;
    }

    public ObjectWriter createWriter(OutputStream os) {
        return new JsonWriter(new OutputStreamWriter(os, UTF8_CHARSET), this.skipNull, this.htmlSafe, this.indent);
    }

    public ObjectWriter createWriter(OutputStream os, Charset charset) {
        return this.createWriter(new OutputStreamWriter(os, charset));
    }

    public ObjectWriter createWriter(Writer writer) {
        return new JsonWriter(writer, this.skipNull, this.htmlSafe, this.indent);
    }

    public ObjectReader createReader(byte[] in) {
        return this.createReader(new ByteArrayInputStream(in));
    }

    public ObjectReader createReader(InputStream is) {
        return this.createReader(is, UTF8_CHARSET);
    }

    public ObjectReader createReader(InputStream is, Charset charset) {
        return this.createReader(new InputStreamReader(is, charset));
    }

    public ObjectReader createReader(Reader reader) {
        return new JsonReader(reader, this.strictDoubleParse, this.withMetadata);
    }

    public boolean isSkipNull() {
        return this.skipNull;
    }

    public boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public boolean isWithClassMetadata() {
        return this.withClassMetadata;
    }

    public BeanDescriptorProvider getBeanDescriptorProvider() {
        return this.beanDescriptorFactory;
    }

    public Converter<Object> getNullConverter() {
        return this.nullConverter;
    }

    public boolean failOnMissingProperty() {
        return this.failOnMissingProperty;
    }

    @Deprecated
    public static class Builder
    extends GensonBuilder {
    }
}

