/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jodatime;

import com.owlike.genson.Context;
import com.owlike.genson.Deserializer;
import com.owlike.genson.Serializer;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import com.owlike.genson.stream.ValueType;
import java.util.Arrays;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

public final class ReadableInstantSerDe {
    public static List<ReadableInstantDeser<? extends ReadableInstant>> readableInstantDesers() {
        return Arrays.asList(new ReadableInstantDeser<DateTime>(){

            @Override
            protected DateTime fromLong(long value) {
                return new DateTime(value);
            }

            @Override
            protected DateTime fromString(String value) {
                return this.formatter.parseDateTime(value);
            }
        }, new ReadableInstantDeser<MutableDateTime>(){

            @Override
            protected MutableDateTime fromLong(long value) {
                return new MutableDateTime(value);
            }

            @Override
            protected MutableDateTime fromString(String value) {
                return this.formatter.parseMutableDateTime(value);
            }
        }, new ReadableInstantDeser<Instant>(){

            @Override
            protected Instant fromLong(long value) {
                return new Instant(value);
            }

            @Override
            protected Instant fromString(String value) {
                return new Instant((Object)value);
            }
        });
    }

    public static abstract class ReadableInstantDeser<T extends ReadableInstant>
    implements Deserializer<T> {
        protected boolean dateAsMillis;
        protected DateTimeFormatter formatter;

        protected abstract T fromLong(long var1);

        protected abstract T fromString(String var1);

        @Override
        public T deserialize(ObjectReader reader, Context ctx) throws Exception {
            if (ValueType.INTEGER == reader.getValueType()) {
                return this.fromLong(reader.valueAsLong());
            }
            return this.fromString(reader.valueAsString());
        }

        public void setFormatter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setDateAsMillis(boolean dateAsMillis) {
            this.dateAsMillis = dateAsMillis;
        }
    }

    public static class ReadableInstantSer
    implements Serializer<ReadableInstant> {
        private final boolean dateAsMillis;
        private final DateTimeFormatter formatter;

        public ReadableInstantSer(boolean dateAsMillis, DateTimeFormatter formatter) {
            this.dateAsMillis = dateAsMillis;
            this.formatter = formatter;
        }

        @Override
        public void serialize(ReadableInstant object, ObjectWriter writer, Context ctx) throws Exception {
            if (this.dateAsMillis) {
                writer.writeValue(object.getMillis());
            } else {
                writer.writeString(this.formatter.print(object));
            }
        }
    }
}

