/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jodatime;

import com.owlike.genson.GensonBuilder;
import com.owlike.genson.ext.GensonBundle;
import com.owlike.genson.ext.jodatime.DurationConverter;
import com.owlike.genson.ext.jodatime.IntervalConverter;
import com.owlike.genson.ext.jodatime.PeriodConverter;
import com.owlike.genson.ext.jodatime.ReadableInstantSerDe;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class JodaTimeBundle
extends GensonBundle {
    private DateTimeFormatter formatter = ISODateTimeFormat.dateTime();

    @Override
    public void configure(GensonBuilder builder) {
        ReadableInstantSerDe.ReadableInstantSer readableInstantSer = new ReadableInstantSerDe.ReadableInstantSer(builder.isDateAsTimestamp(), this.formatter);
        builder.withSerializer(readableInstantSer, DateTime.class).withSerializer(readableInstantSer, MutableDateTime.class).withSerializer(readableInstantSer, Instant.class).withConverters(new DurationConverter(), new PeriodConverter()).withConverterFactory(new IntervalConverter.ConverterFactory());
        this.setupAndRegister(builder, ReadableInstantSerDe.readableInstantDesers());
    }

    protected void setupAndRegister(GensonBuilder builder, List<ReadableInstantSerDe.ReadableInstantDeser<? extends ReadableInstant>> desers) {
        for (ReadableInstantSerDe.ReadableInstantDeser<? extends ReadableInstant> deser : desers) {
            deser.setDateAsMillis(builder.isDateAsTimestamp());
            deser.setFormatter(this.formatter);
            builder.withDeserializers(deser);
        }
    }

    public JodaTimeBundle useDateFormatter(DateTimeFormatter formatter) {
        this.formatter = formatter;
        return this;
    }
}

