/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.convert;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Genson;
import com.owlike.genson.Wrapper;
import com.owlike.genson.annotation.HandleNull;
import com.owlike.genson.convert.ChainedFactory;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import com.owlike.genson.stream.ValueType;
import java.lang.reflect.Type;

public class NullConverter
implements Converter<Object> {
    @Override
    public void serialize(Object obj, ObjectWriter writer, Context ctx) {
        writer.writeNull();
    }

    @Override
    public Object deserialize(ObjectReader reader, Context ctx) {
        return null;
    }

    public static class NullConverterWrapper<T>
    extends Wrapper<Converter<T>>
    implements Converter<T> {
        private final Converter<Object> nullConverter;

        public NullConverterWrapper(Converter<Object> nullConverter, Converter<T> converter) {
            super(converter);
            this.nullConverter = nullConverter;
        }

        @Override
        public void serialize(T obj, ObjectWriter writer, Context ctx) throws Exception {
            if (obj == null) {
                this.nullConverter.serialize(obj, writer, ctx);
            } else {
                ((Converter)this.wrapped).serialize(obj, writer, ctx);
            }
        }

        @Override
        public T deserialize(ObjectReader reader, Context ctx) throws Exception {
            if (ValueType.NULL == reader.getValueType()) {
                return (T)this.nullConverter.deserialize(reader, ctx);
            }
            return ((Converter)this.wrapped).deserialize(reader, ctx);
        }
    }

    public static class NullConverterFactory
    extends ChainedFactory {
        @Override
        protected Converter<?> create(Type type, Genson genson, Converter<?> nextConverter) {
            return Wrapper.toAnnotatedElement(nextConverter).isAnnotationPresent(HandleNull.class) ? nextConverter : new NullConverterWrapper(genson.getNullConverter(), nextConverter);
        }
    }
}

