/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jodatime;

import com.owlike.genson.Converter;
import com.owlike.genson.Genson;
import com.owlike.genson.GensonBuilder;
import com.owlike.genson.annotation.JsonDateFormat;
import com.owlike.genson.convert.ContextualFactory;
import com.owlike.genson.ext.GensonBundle;
import com.owlike.genson.ext.jodatime.BaseLocalConverter;
import com.owlike.genson.ext.jodatime.BaseReadableInstantConverter;
import com.owlike.genson.ext.jodatime.DurationConverter;
import com.owlike.genson.ext.jodatime.IntervalConverter;
import com.owlike.genson.ext.jodatime.PeriodConverter;
import com.owlike.genson.reflect.BeanProperty;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.MutableDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class JodaTimeBundle
extends GensonBundle {
    private DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();
    private DateTimeFormatter localDateFormatter = ISODateTimeFormat.date().withZone(DateTimeZone.getDefault());
    private DateTimeFormatter localDateTimeFormatter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.getDefault());
    private DateTimeFormatter localTimeFormatter = ISODateTimeFormat.time().withZone(DateTimeZone.getDefault());

    @Override
    public void configure(GensonBuilder builder) {
        builder.withContextualFactory(new JodaTimeConverterContextualFactory()).withConverters(new DurationConverter(), new PeriodConverter(), BaseReadableInstantConverter.makeDateTimeConverter(builder.isDateAsTimestamp(), this.dateTimeFormatter), BaseReadableInstantConverter.makeMutableDateTimeConverter(builder.isDateAsTimestamp(), this.dateTimeFormatter), BaseReadableInstantConverter.makeInstantConverter(builder.isDateAsTimestamp(), this.dateTimeFormatter), BaseLocalConverter.makeLocalDateConverter(this.localDateFormatter), BaseLocalConverter.makeLocalDateTimeConverter(this.localDateTimeFormatter), BaseLocalConverter.makeLocalTimeConverter(this.localTimeFormatter)).withConverterFactory(new IntervalConverter.ConverterFactory());
    }

    public JodaTimeBundle useDateTimeFormatter(DateTimeFormatter formatter) {
        this.dateTimeFormatter = formatter;
        return this;
    }

    public JodaTimeBundle useLocalDateFormatter(DateTimeFormatter formatter) {
        this.localDateFormatter = formatter;
        return this;
    }

    public JodaTimeBundle useLocalDateTimeFormatter(DateTimeFormatter formatter) {
        this.localDateTimeFormatter = formatter;
        return this;
    }

    public JodaTimeBundle useLocalTimeFormatter(DateTimeFormatter formatter) {
        this.localTimeFormatter = formatter;
        return this;
    }

    private final class JodaTimeConverterContextualFactory
    implements ContextualFactory {
        private JodaTimeConverterContextualFactory() {
        }

        public Converter create(BeanProperty property, Genson genson) {
            JsonDateFormat ann = property.getAnnotation(JsonDateFormat.class);
            if (ann != null) {
                if (MutableDateTime.class.isAssignableFrom(property.getRawClass())) {
                    return BaseReadableInstantConverter.makeMutableDateTimeConverter(ann.asTimeInMillis(), this.formatter(ann, JodaTimeBundle.this.dateTimeFormatter));
                }
                if (DateTime.class.isAssignableFrom(property.getRawClass())) {
                    return BaseReadableInstantConverter.makeDateTimeConverter(ann.asTimeInMillis(), this.formatter(ann, JodaTimeBundle.this.dateTimeFormatter));
                }
                if (LocalDate.class.isAssignableFrom(property.getRawClass())) {
                    return BaseLocalConverter.makeLocalDateConverter(this.formatter(ann, JodaTimeBundle.this.localDateFormatter));
                }
                if (LocalDateTime.class.isAssignableFrom(property.getRawClass())) {
                    return BaseLocalConverter.makeLocalDateTimeConverter(this.formatter(ann, JodaTimeBundle.this.localDateTimeFormatter));
                }
                if (LocalTime.class.isAssignableFrom(property.getRawClass())) {
                    return BaseLocalConverter.makeLocalTimeConverter(this.formatter(ann, JodaTimeBundle.this.localTimeFormatter));
                }
            }
            return null;
        }

        private DateTimeFormatter formatter(JsonDateFormat ann, DateTimeFormatter defaultFormatter) {
            Locale locale;
            Locale locale2 = locale = ann.lang().isEmpty() ? Locale.getDefault() : new Locale(ann.lang());
            if (ann.value() == null || ann.value().isEmpty()) {
                return defaultFormatter;
            }
            return DateTimeFormat.forPattern((String)ann.value()).withLocale(locale);
        }
    }
}

