/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.Context;
import com.owlike.genson.JsonBindingException;
import com.owlike.genson.Serializer;
import com.owlike.genson.reflect.BeanProperty;
import com.owlike.genson.stream.ObjectWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public abstract class PropertyAccessor
extends BeanProperty
implements Comparable<PropertyAccessor> {
    Serializer<Object> propertySerializer;

    protected PropertyAccessor(String name, Type type, Class<?> declaringClass, Annotation[] annotations, int modifiers) {
        super(name, type, declaringClass, annotations, modifiers);
    }

    public void serialize(Object propertySource, ObjectWriter writer, Context ctx) {
        Object propertyValue = this.access(propertySource);
        writer.writeName(this.name);
        try {
            this.propertySerializer.serialize(propertyValue, writer, ctx);
        }
        catch (Throwable th) {
            throw this.couldNotSerialize(th);
        }
    }

    public abstract Object access(Object var1);

    @Override
    public int compareTo(PropertyAccessor o) {
        return o.priority() - this.priority();
    }

    protected JsonBindingException couldNotAccess(Exception e) {
        return new JsonBindingException("Could not access value of property named '" + this.name + "' using accessor " + this.signature() + " from class " + this.declaringClass.getName(), e);
    }

    protected JsonBindingException couldNotSerialize(Throwable e) {
        return new JsonBindingException("Could not serialize property '" + this.name + "' from class " + this.declaringClass.getName(), e);
    }

    public static class FieldAccessor
    extends PropertyAccessor {
        protected final Field _field;

        public FieldAccessor(String name, Field field, Type type, Class<?> declaringClass) {
            super(name, type, declaringClass, field.getAnnotations(), field.getModifiers());
            this._field = field;
            if (!this._field.isAccessible()) {
                this._field.setAccessible(true);
            }
        }

        @Override
        public Object access(Object target) {
            try {
                return this._field.get(target);
            }
            catch (IllegalArgumentException e) {
                throw this.couldNotAccess(e);
            }
            catch (IllegalAccessException e) {
                throw this.couldNotAccess(e);
            }
        }

        @Override
        public String signature() {
            return this._field.toGenericString();
        }

        @Override
        public int priority() {
            return 50;
        }
    }

    public static class MethodAccessor
    extends PropertyAccessor {
        protected final Method _getter;

        public MethodAccessor(String name, Method getter, Type type, Class<?> declaringClass) {
            super(name, type, declaringClass, getter.getAnnotations(), getter.getModifiers());
            this._getter = getter;
            if (!this._getter.isAccessible()) {
                this._getter.setAccessible(true);
            }
        }

        @Override
        public Object access(Object target) {
            try {
                return this._getter.invoke(target, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw this.couldNotAccess(e);
            }
            catch (IllegalAccessException e) {
                throw this.couldNotAccess(e);
            }
            catch (InvocationTargetException e) {
                throw this.couldNotAccess(e);
            }
        }

        @Override
        String signature() {
            return this._getter.toGenericString();
        }

        @Override
        int priority() {
            return 100;
        }
    }
}

