/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jodatime;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.annotation.HandleBeanView;
import com.owlike.genson.annotation.HandleClassMetadata;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import com.owlike.genson.stream.ValueType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.base.BaseLocal;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@HandleClassMetadata
@HandleBeanView
public abstract class BaseLocalConverter<T extends BaseLocal>
implements Converter<T> {
    protected final DateTimeFormatter formatter;

    protected BaseLocalConverter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public void serialize(T object, ObjectWriter writer, Context ctx) throws Exception {
        writer.writeString(this.formatter.print(object));
    }

    @Override
    public T deserialize(ObjectReader reader, Context ctx) throws Exception {
        if (ValueType.INTEGER == reader.getValueType()) {
            return this.fromLong(reader.valueAsLong());
        }
        return this.fromString(reader.valueAsString());
    }

    protected abstract T fromLong(long var1);

    protected abstract T fromString(String var1);

    static BaseLocalConverter<LocalDate> makeLocalDateConverter(DateTimeFormatter formatter) {
        return new BaseLocalConverter<LocalDate>(formatter){

            @Override
            protected LocalDate fromString(String value) {
                return this.formatter.parseLocalDate(value);
            }

            @Override
            protected LocalDate fromLong(long value) {
                return new LocalDate(value);
            }
        };
    }

    static BaseLocalConverter<LocalDateTime> makeLocalDateTimeConverter(DateTimeFormatter formatter) {
        return new BaseLocalConverter<LocalDateTime>(formatter){
            private final DateTimeFormatter localFormatter = ISODateTimeFormat.localDateOptionalTimeParser();

            @Override
            protected LocalDateTime fromString(String value) {
                return this.localFormatter.parseLocalDateTime(value);
            }

            @Override
            protected LocalDateTime fromLong(long value) {
                return new LocalDateTime(value);
            }
        };
    }

    static BaseLocalConverter<LocalTime> makeLocalTimeConverter(DateTimeFormatter formatter) {
        return new BaseLocalConverter<LocalTime>(formatter){
            private final DateTimeFormatter localFormatter = ISODateTimeFormat.localTimeParser();

            @Override
            protected LocalTime fromString(String value) {
                return this.localFormatter.parseLocalTime(value);
            }

            @Override
            protected LocalTime fromLong(long value) {
                return new LocalTime(value);
            }
        };
    }
}

