/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jodatime;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Factory;
import com.owlike.genson.Genson;
import com.owlike.genson.annotation.HandleBeanView;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.lang.reflect.Type;
import org.joda.time.DateTime;
import org.joda.time.Interval;

@HandleBeanView
public class IntervalConverter
implements Converter<Interval> {
    private final Converter<DateTime> dateTimeConverter;

    public IntervalConverter(Converter<DateTime> dateTimeConverter) {
        this.dateTimeConverter = dateTimeConverter;
    }

    @Override
    public void serialize(Interval interval, ObjectWriter writer, Context ctx) throws Exception {
        writer.beginObject();
        writer.writeName("start");
        this.dateTimeConverter.serialize(interval.getStart(), writer, ctx);
        writer.writeName("end");
        this.dateTimeConverter.serialize(interval.getEnd(), writer, ctx);
        writer.endObject();
    }

    @Override
    public Interval deserialize(ObjectReader reader, Context ctx) throws Exception {
        DateTime start = null;
        DateTime end = null;
        reader.beginObject();
        while (reader.hasNext()) {
            reader.next();
            if ("start".equals(reader.name())) {
                start = this.dateTimeConverter.deserialize(reader, ctx);
                continue;
            }
            if ("end".equals(reader.name())) {
                end = this.dateTimeConverter.deserialize(reader, ctx);
                continue;
            }
            throw new IllegalStateException("Encountered unexpected property " + reader.name() + " and value " + reader.valueAsString());
        }
        reader.endObject();
        return new Interval(start, end);
    }

    public static class ConverterFactory
    implements Factory<Converter<Interval>> {
        @Override
        public Converter<Interval> create(Type type, Genson genson) {
            return new IntervalConverter(genson.provideConverter((Type)((Object)DateTime.class)));
        }
    }
}

