/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="The AfterburnerModule is not compatible with jdk16+ and will cause failures at runtime. Either remove AfterburnerModule, or replace it with 'conjure-java-jackson-optimizations' ObjectMapperOptimizations.createModules() to take the runtime into account.")
@AutoService(value={BugChecker.class})
public final class AfterburnerJavaIncompatibility
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.constructor().forClass("com.fasterxml.jackson.module.afterburner.AfterburnerModule");

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return MATCHER.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

