/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.safety.Safety;
import com.palantir.baseline.errorprone.safety.SafetyAnalysis;
import com.palantir.baseline.errorprone.safety.SafetyAnnotations;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.util.Objects;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="safe-logging annotations must agree between args and method parameters")
@AutoService(value={BugChecker.class})
public final class IllegalSafeLoggingArgument
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.ReturnTreeMatcher,
BugChecker.AssignmentTreeMatcher,
BugChecker.CompoundAssignmentTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final String UNSAFE_ARG = "com.palantir.logsafe.UnsafeArg";
    private static final Matcher<ExpressionTree> SAFE_ARG_OF_METHOD_MATCHER = MethodMatchers.staticMethod().onClass("com.palantir.logsafe.SafeArg").named("of");

    private static Type resolveParameterType(Type input, MethodInvocationTree tree, VisitorState state) {
        if (input instanceof Type.TypeVar) {
            Type.TypeVar typeVar = (Type.TypeVar)input;
            Type receiver = ASTHelpers.getReceiverType((ExpressionTree)tree);
            if (receiver == null) {
                return input;
            }
            Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
            Type boundToMethodOwner = state.getTypes().asSuper(receiver, methodSymbol.owner);
            List<Symbol.TypeVariableSymbol> ownerTypeVars = methodSymbol.owner.getTypeParameters();
            if (ownerTypeVars.size() == boundToMethodOwner.getTypeArguments().size()) {
                for (int i = 0; i < ownerTypeVars.size(); ++i) {
                    Symbol.TypeVariableSymbol ownerVar = (Symbol.TypeVariableSymbol)ownerTypeVars.get(i);
                    if (!Objects.equals(ownerVar, typeVar.tsym)) continue;
                    return boundToMethodOwner.getTypeArguments().get(i);
                }
            }
        }
        return input;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        java.util.List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.isEmpty()) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (methodSymbol == null) {
            return Description.NO_MATCH;
        }
        java.util.List parameters = methodSymbol.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Symbol.VarSymbol parameter = (Symbol.VarSymbol)parameters.get(i);
            Type resolvedParameterType = IllegalSafeLoggingArgument.resolveParameterType(parameter.type, tree, state);
            Safety parameterSafety = Safety.mergeAssumingUnknownIsSame(SafetyAnnotations.getSafety(parameter, state), SafetyAnnotations.getSafety(resolvedParameterType, state));
            if (parameterSafety.allowsAll()) continue;
            int limit = methodSymbol.isVarArgs() && i == parameters.size() - 1 ? arguments.size() : i + 1;
            for (int j = i; j < limit; ++j) {
                ExpressionTree argument = arguments.get(j);
                Safety argumentSafety = SafetyAnalysis.of(state.withPath(new TreePath(state.getPath(), argument)));
                if (parameterSafety.allowsValueWith(argumentSafety)) continue;
                state.reportMatch(this.buildDescription(argument).setMessage(String.format("Dangerous argument value: arg is '%s' but the parameter requires '%s'.", new Object[]{argumentSafety, parameterSafety})).addFix((Fix)IllegalSafeLoggingArgument.getSuggestedFix(tree, state, argumentSafety)).build());
            }
        }
        return Description.NO_MATCH;
    }

    private static SuggestedFix getSuggestedFix(MethodInvocationTree tree, VisitorState state, Safety argumentSafety) {
        if (SAFE_ARG_OF_METHOD_MATCHER.matches((Tree)tree, state) && Safety.UNSAFE.allowsValueWith(argumentSafety)) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String unsafeQualifiedClassName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)UNSAFE_ARG);
            String replacement = String.format("%s.of", unsafeQualifiedClassName);
            return fix.replace((Tree)tree.getMethodSelect(), replacement).build();
        }
        return SuggestedFix.emptyFix();
    }

    public Description matchReturn(ReturnTree tree, VisitorState state) {
        TreePath path;
        if (tree.getExpression() == null) {
            return Description.NO_MATCH;
        }
        for (path = state.getPath(); path != null && path.getLeaf() instanceof StatementTree; path = path.getParentPath()) {
        }
        if (path == null || !(path.getLeaf() instanceof MethodTree)) {
            return Description.NO_MATCH;
        }
        MethodTree method = (MethodTree)path.getLeaf();
        Safety methodDeclaredSafety = SafetyAnnotations.getSafety(ASTHelpers.getSymbol((MethodTree)method), state);
        if (methodDeclaredSafety.allowsAll()) {
            return Description.NO_MATCH;
        }
        Safety returnValueSafety = SafetyAnalysis.of(state.withPath(new TreePath(state.getPath(), tree.getExpression())));
        if (methodDeclaredSafety.allowsValueWith(returnValueSafety)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("Dangerous return value: result is '%s' but the method is annotated '%s'.", new Object[]{returnValueSafety, methodDeclaredSafety})).build();
    }

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        return this.handleAssignment(tree, tree.getVariable(), tree.getExpression(), state);
    }

    public Description matchCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        return this.handleAssignment(tree, tree.getVariable(), tree.getExpression(), state);
    }

    private Description handleAssignment(ExpressionTree assignmentTree, ExpressionTree variable, ExpressionTree expression, VisitorState state) {
        Safety variableDeclaredSafety = SafetyAnnotations.getSafety(variable, state);
        if (variableDeclaredSafety.allowsAll()) {
            return Description.NO_MATCH;
        }
        Safety assignmentValue = SafetyAnalysis.of(state.withPath(new TreePath(state.getPath(), expression)));
        if (variableDeclaredSafety.allowsValueWith(assignmentValue)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(assignmentTree).setMessage(String.format("Dangerous assignment: value is '%s' but the variable is annotated '%s'.", new Object[]{assignmentValue, variableDeclaredSafety})).build();
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Tree returnType = tree.getReturnType();
        if (returnType == null) {
            return Description.NO_MATCH;
        }
        Safety methodSafetyAnnotation = SafetyAnnotations.getSafety(ASTHelpers.getSymbol((MethodTree)tree), state);
        if (methodSafetyAnnotation.allowsAll()) {
            return Description.NO_MATCH;
        }
        Safety returnTypeSafety = SafetyAnnotations.getSafety(ASTHelpers.getSymbol((Tree)returnType), state);
        if (methodSafetyAnnotation.allowsValueWith(returnTypeSafety)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(returnType).setMessage(String.format("Dangerous return type: type is '%s' but the method is annotated '%s'.", new Object[]{returnTypeSafety, methodSafetyAnnotation})).build();
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Safety parameterSafetyAnnotation = SafetyAnnotations.getSafety(ASTHelpers.getSymbol((VariableTree)tree), state);
        if (parameterSafetyAnnotation.allowsAll()) {
            return Description.NO_MATCH;
        }
        Safety variableTypeSafety = SafetyAnnotations.getSafety(ASTHelpers.getSymbol((Tree)tree.getType()), state);
        if (parameterSafetyAnnotation.allowsValueWith(variableTypeSafety)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("Dangerous variable: type is '%s' but the variable is annotated '%s'.", new Object[]{variableTypeSafety, parameterSafetyAnnotation})).build();
    }
}

