/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@BugPattern(linkType=BugPattern.LinkType.CUSTOM, link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", severity=BugPattern.SeverityLevel.ERROR, summary="All required fields of an Immutables builder must be initialized")
@AutoService(value={BugChecker.class})
public final class ImmutablesBuilderMissingInitialization
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String FIELD_INIT_BITS_PREFIX = "INIT_BIT_";
    private static final ImmutableSet<String> GET_PREFIXES = ImmutableSet.of((Object)"GET_", (Object)"IS_");
    private static final Matcher<ExpressionTree> builderMethodMatcher = Matchers.instanceMethod().onClass(ImmutablesBuilderMissingInitialization::extendsImmutablesGeneratedClass).named("build").withNoParameters();
    private static final Supplier<Name> GENERATOR = VisitorState.memoize((Supplier & Serializable)state -> state.getName("generator"));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!builderMethodMatcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol builderClass = ASTHelpers.enclosingClass((Symbol)ASTHelpers.getSymbol((MethodInvocationTree)tree));
        Symbol.ClassSymbol immutableClass = ASTHelpers.enclosingClass((Symbol)builderClass);
        if (immutableClass == null) {
            return Description.NO_MATCH;
        }
        Optional<Symbol.ClassSymbol> interfaceClass = Streams.concat((Stream[])new Stream[]{immutableClass.getInterfaces().stream(), Stream.of(immutableClass.getSuperclass())}).map(type -> type.tsym).map(this.filterByType(Symbol.ClassSymbol.class)).flatMap(Streams::stream).filter(classSymbol -> ASTHelpers.hasAnnotation((Symbol)classSymbol, (String)"org.immutables.value.Value.Immutable", (VisitorState)state)).findAny();
        if (!interfaceClass.isPresent()) {
            return Description.NO_MATCH;
        }
        Set<String> requiredFields = Streams.stream(builderClass.members().getSymbols()).filter(Symbol::isStatic).filter(symbol -> symbol.getKind().isField()).filter(symbol -> symbol.getSimpleName().toString().startsWith(FIELD_INIT_BITS_PREFIX)).map(Symbol::toString).map(initBitsName -> this.removeFromStart((String)initBitsName, FIELD_INIT_BITS_PREFIX)).map(fieldName -> GET_PREFIXES.stream().reduce(fieldName, this::removeFromStart)).map(CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL)).collect(Collectors.toSet());
        if (!this.checkAllFieldsCanBeInitialized(requiredFields, builderClass)) {
            return Description.NO_MATCH;
        }
        Set<String> uninitializedFields = this.checkInitialization(ASTHelpers.getReceiver((ExpressionTree)tree), requiredFields, state, builderClass, immutableClass, interfaceClass.get());
        if (uninitializedFields.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("Some builder fields have not been initialized: %s", Joiner.on((String)", ").join(uninitializedFields))).build();
    }

    private Set<String> checkInitialization(ExpressionTree tree, Set<String> uninitializedFields, VisitorState state, Symbol.ClassSymbol builderClass, Symbol.ClassSymbol immutableClass, Symbol.ClassSymbol interfaceClass) {
        if (uninitializedFields.isEmpty()) {
            return ImmutableSet.of();
        }
        if (tree instanceof MethodInvocationTree) {
            Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)tree));
            if (!Objects.equals(methodSymbol.enclClass(), builderClass)) {
                if (this.methodJustConstructsBuilder(methodSymbol, state, immutableClass, interfaceClass)) {
                    return uninitializedFields;
                }
                return ImmutableSet.of();
            }
            if (((Name)methodSymbol.getSimpleName()).contentEquals("from")) {
                return ImmutableSet.of();
            }
            return this.checkInitialization(ASTHelpers.getReceiver((ExpressionTree)tree), this.removeFieldsPotentiallyInitializedBy(uninitializedFields, ((Name)methodSymbol.getSimpleName()).toString()), state, builderClass, immutableClass, interfaceClass);
        }
        if (tree instanceof NewClassTree) {
            NewClassTree newClassTree = (NewClassTree)tree;
            if (newClassTree.getArguments().isEmpty()) {
                return uninitializedFields;
            }
            return ImmutableSet.of();
        }
        return ImmutableSet.of();
    }

    private boolean checkAllFieldsCanBeInitialized(Set<String> fields, Symbol builderClass) {
        return Streams.stream(builderClass.members().getSymbols()).map(this.filterByType(Symbol.MethodSymbol.class)).flatMap(Streams::stream).filter(symbol -> !symbol.isStaticOrInstanceInit() && !symbol.isConstructor() && !symbol.isAnonymous() && ((List)symbol.getParameters()).size() == 1).map(symbol -> ((Name)symbol.getSimpleName()).toString()).reduce(fields, this::removeFieldsPotentiallyInitializedBy, Sets::intersection).isEmpty();
    }

    private Set<String> removeFieldsPotentiallyInitializedBy(Set<String> uninitializedFields, String methodName) {
        String methodNameLowerCase = methodName.toLowerCase();
        return uninitializedFields.stream().filter(fieldName -> !methodNameLowerCase.endsWith(fieldName.toLowerCase())).collect(Collectors.toSet());
    }

    private boolean methodJustConstructsBuilder(Symbol.MethodSymbol methodSymbol, VisitorState state, Symbol.ClassSymbol immutableClass, Symbol.ClassSymbol interfaceClass) {
        MethodTree methodTree = ASTHelpers.findMethod((Symbol.MethodSymbol)methodSymbol, (VisitorState)state);
        if (methodTree != null && methodTree.getBody() != null) {
            if (methodTree.getBody().getStatements().size() != 1) {
                return false;
            }
            return methodTree.getBody().getStatements().stream().findAny().flatMap(this.filterByType(ReturnTree.class)).map(ReturnTree::getExpression).map(expressionTree -> {
                if (expressionTree instanceof NewClassTree) {
                    return ((NewClassTree)expressionTree).getArguments().isEmpty();
                }
                if (expressionTree instanceof MethodInvocationTree) {
                    return Optional.ofNullable(ASTHelpers.getSymbol((Tree)expressionTree)).flatMap(this.filterByType(Symbol.MethodSymbol.class)).filter(symbol -> ((List)symbol.getParameters()).isEmpty()).filter(symbol -> ((Name)symbol.getSimpleName()).contentEquals("builder")).map(Symbol::enclClass).flatMap(this.filterByType(Symbol.ClassSymbol.class)).filter(symbol -> symbol.equals(immutableClass)).isPresent();
                }
                return false;
            }).orElse(false);
        }
        return (Objects.equals(methodSymbol.enclClass(), immutableClass) || Objects.equals(methodSymbol.enclClass(), interfaceClass)) && ((Name)methodSymbol.getSimpleName()).contentEquals("builder") && ((List)methodSymbol.getParameters()).isEmpty();
    }

    private String removeFromStart(String input, String toRemove) {
        if (input.startsWith(toRemove)) {
            return input.substring(toRemove.length());
        }
        return input;
    }

    private <I, O extends I> Function<I, Optional<O>> filterByType(Class<O> clazz) {
        return value -> {
            if (clazz.isInstance(value)) {
                return Optional.of(clazz.cast(value));
            }
            return Optional.empty();
        };
    }

    private static boolean extendsImmutablesGeneratedClass(Type type, VisitorState state) {
        if (type.tsym instanceof Symbol.ClassSymbol) {
            return type.tsym.getRawAttributes().stream().filter(compound -> compound.type.tsym.getQualifiedName().contentEquals("org.immutables.value.Generated")).map(annotation -> annotation.member((Name)GENERATOR.get(state))).filter(Objects::nonNull).anyMatch(attribute -> Objects.equals(attribute.getValue(), "Immutables")) || ImmutablesBuilderMissingInitialization.extendsImmutablesGeneratedClass(((Symbol.ClassSymbol)type.tsym).getSuperclass(), state);
        }
        return false;
    }
}

