/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Args with type Throwable are not allowed.")
@AutoService(value={BugChecker.class})
public final class LogsafeArgument
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.staticMethod().onClassAny(new String[]{"com.palantir.logsafe.SafeArg", "com.palantir.logsafe.UnsafeArg"}).named("of").withParameters(String.class.getName(), new String[]{Object.class.getName()});
    private static final Matcher<ExpressionTree> THROWABLE = MoreMatchers.isSubtypeOf(Throwable.class.getName());

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> args;
        if (MATCHER.matches((Tree)tree, state) && THROWABLE.matches((Tree)(args = tree.getArguments()).get(1), state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

