/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.io.Serializable;
import java.util.Locale;
import javax.lang.model.element.Modifier;

final class MoreMatchers {
    static <T extends Tree> Matcher<T> isSubtypeOf(Class<?> baseType) {
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.isSubtypeOf(baseType), Matchers.not((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.NULL_LITERAL))});
    }

    static <T extends Tree> Matcher<T> isSubtypeOf(String baseTypeString) {
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.isSubtypeOf((String)baseTypeString), Matchers.not((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.NULL_LITERAL))});
    }

    static <T extends ClassTree> Matcher<T> classEnclosingClass(Matcher<ClassTree> matcher) {
        return (Matcher & Serializable)(classTree, state) -> {
            for (TreePath currentPath = state.getPath().getParentPath(); currentPath != null; currentPath = currentPath.getParentPath()) {
                Tree leaf = currentPath.getLeaf();
                if (!(leaf instanceof ClassTree)) continue;
                return matcher.matches((Tree)((ClassTree)leaf), state);
            }
            return false;
        };
    }

    static <T extends Tree> Matcher<T> hasExplicitModifier(Modifier modifier) {
        return (Matcher & Serializable)(tree, state) -> {
            if (tree instanceof ClassTree) {
                return MoreMatchers.containsModifier(((ClassTree)tree).getModifiers(), state, modifier);
            }
            if (tree instanceof MethodTree) {
                return MoreMatchers.containsModifier(((MethodTree)tree).getModifiers(), state, modifier);
            }
            if (tree instanceof VariableTree) {
                return MoreMatchers.containsModifier(((VariableTree)tree).getModifiers(), state, modifier);
            }
            return false;
        };
    }

    private static boolean containsModifier(ModifiersTree tree, VisitorState state, Modifier modifier) {
        if (!tree.getFlags().contains((Object)modifier)) {
            return false;
        }
        String source = state.getSourceForNode((Tree)tree);
        if (source == null) {
            return false;
        }
        return source.contains(modifier.name().toLowerCase(Locale.ENGLISH));
    }

    static Matcher<MethodTree> hasSignature(String signature) {
        return (Matcher & Serializable)(methodTree, state) -> {
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)methodTree);
            if (symbol == null) {
                return false;
            }
            return signature.equals(symbol.toString());
        };
    }

    private MoreMatchers() {
    }
}

