/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Prefer Guava's Lists.partition(List, int) instead of Iterables.partition(Iterable, int) when first argument's declared type is a list for performance reasons, cf. https://github.com/palantir/gradle-baseline/issues/621")
@AutoService(value={BugChecker.class})
public final class PreferListsPartition
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_MESSAGE = "Prefer Lists.partition";
    private static final Matcher<ExpressionTree> ITERABLES_PARTITION_MATCHER = MethodMatchers.staticMethod().onClass("com.google.common.collect.Iterables").named("partition").withParameters("java.lang.Iterable", new String[]{"int"});
    private static final Matcher<Tree> LIST_MATCHER = MoreMatchers.isSubtypeOf("java.util.List");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (ITERABLES_PARTITION_MATCHER.matches((Tree)tree, state)) {
            List<? extends ExpressionTree> args = tree.getArguments();
            if (args.size() <= 1) {
                return Description.NO_MATCH;
            }
            if (LIST_MATCHER.matches((Tree)args.get(0), state)) {
                SuggestedFix.Builder fix = SuggestedFix.builder();
                String qualifiedType = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"com.google.common.collect.Lists");
                String method = qualifiedType + ".partition";
                return this.buildDescription(tree).setMessage(ERROR_MESSAGE).addFix((Fix)fix.replace((Tree)tree.getMethodSelect(), method).build()).build();
            }
        }
        return Description.NO_MATCH;
    }
}

