/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Precondition and similar checks with a constant message and no parameters should use equivalent checks from com.palantir.logsafe.Preconditions for standardization as functionality is the same.")
@AutoService(value={BugChecker.class})
public final class PreferSafeLoggingPreconditions
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private final Matcher<ExpressionTree> compileTimeConstExpressionMatcher = new CompileTimeConstantExpressionMatcher();
    private static final Matcher<ExpressionTree> PRECONDITIONS_MATCHER = MethodMatchers.staticMethod().onClass("com.google.common.base.Preconditions").withNameMatching(Pattern.compile("checkArgument|checkState|checkNotNull"));
    private static final Matcher<ExpressionTree> METHOD_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{PRECONDITIONS_MATCHER, MethodMatchers.staticMethod().onClass("java.util.Objects").named("requireNonNull"), MethodMatchers.staticMethod().onClass("org.apache.commons.lang3.Validate").withNameMatching(Pattern.compile("isTrue|notNull|validState"))});
    private static final Matcher<ExpressionTree> ARG_MATCHER = MoreMatchers.isSubtypeOf("com.palantir.logsafe.Arg");
    private static final ImmutableMap<String, String> TRANSLATIONS_TO_LOGSAFE_PRECONDITIONS_METHODS = ImmutableMap.of((Object)"requireNonNull", (Object)"checkNotNull", (Object)"isTrue", (Object)"checkArgument", (Object)"notNull", (Object)"checkNotNull", (Object)"validState", (Object)"checkState");
    private static final Supplier<Type> JAVA_STRING = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.String"));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!METHOD_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (TestCheckUtils.isTestCode(state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = tree.getArguments();
        if (args.size() >= 2) {
            ExpressionTree messageArg = args.get(1);
            boolean isStringType = ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)messageArg), (Type)((Type)JAVA_STRING.get(state)), (VisitorState)state);
            if (!isStringType || !this.compileTimeConstExpressionMatcher.matches((Tree)messageArg, state)) {
                return Description.NO_MATCH;
            }
            return this.checkGuavaPreconditionsAndLogsafeArgMixing(tree, state, args);
        }
        return this.suggestFix(tree, state);
    }

    private Description checkGuavaPreconditionsAndLogsafeArgMixing(MethodInvocationTree tree, VisitorState state, List<? extends ExpressionTree> args) {
        boolean anyMatch = false;
        boolean allMatch = true;
        for (int i = 2; i < args.size(); ++i) {
            ExpressionTree arg = args.get(i);
            if (ARG_MATCHER.matches((Tree)arg, state)) {
                anyMatch = true;
                continue;
            }
            allMatch = false;
        }
        if (allMatch) {
            return this.suggestFix(tree, state);
        }
        if (anyMatch) {
            return this.buildDescription(tree).setMessage("An Arg was passed to Preconditions.checkX(), but not all. Convert the non-Args to be Args and use com.palantir.logsafe.Preconditions instead.").build();
        }
        return Description.NO_MATCH;
    }

    private Description suggestFix(MethodInvocationTree tree, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String logSafeQualifiedClassName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"com.palantir.logsafe.Preconditions");
        String logSafeMethodName = PreferSafeLoggingPreconditions.getLogSafeMethodName(ASTHelpers.getSymbol((MethodInvocationTree)tree));
        String replacement = String.format("%s.%s", logSafeQualifiedClassName, logSafeMethodName);
        return this.buildDescription(tree).setMessage("The call can be replaced with an equivalent one from com.palantir.logsafe.Preconditions for standardization as the functionality is the same.").addFix((Fix)fix.replace((Tree)tree.getMethodSelect(), replacement).build()).build();
    }

    private static String getLogSafeMethodName(Symbol.MethodSymbol methodSymbol) {
        String name = methodSymbol.name.toString();
        return (String)TRANSLATIONS_TO_LOGSAFE_PRECONDITIONS_METHODS.getOrDefault((Object)name, (Object)name);
    }
}

