/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.reflect.Reflection;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Proxy instances should be created using constant types known at compile time to allow native-image behavior to match hotspot. Methods which build proxies should take a `Function<InvocationHandler, ? extends T>` instead of arbitrary class references. This check can be safely suppressed in legacy code using @SuppressWarnings(\"ProxyNonConstantType\"). The proxy annotation processor can make this process much easier: https://github.com/palantir/proxy-processor\nSee https://www.graalvm.org/reference-manual/native-image/DynamicProxy/#automatic-detection")
@AutoService(value={BugChecker.class})
public final class ProxyNonConstantType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> NEW_PROXY_INSTANCE_MATCHER = MethodMatchers.staticMethod().onClass(Proxy.class.getName()).named("newProxyInstance");
    private static final Matcher<ExpressionTree> REFLECTION_NEW_PROXY = MethodMatchers.staticMethod().onClass(Reflection.class.getName()).named("newProxy").withParameters(Class.class.getName(), new String[]{InvocationHandler.class.getName()});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree interfaces;
        if (REFLECTION_NEW_PROXY.matches((Tree)tree, state)) {
            return this.describeMatchWithFix(tree, state);
        }
        if (NEW_PROXY_INSTANCE_MATCHER.matches((Tree)tree, state) && (interfaces = tree.getArguments().get(1)) instanceof NewArrayTree) {
            NewArrayTree newArrayTree = (NewArrayTree)interfaces;
            for (ExpressionTree expressionTree : newArrayTree.getInitializers()) {
                if (ProxyNonConstantType.isDirectClassAccess(expressionTree) || TestCheckUtils.isTestCode(state)) continue;
                return this.describeMatchWithFix(interfaces, state);
            }
        }
        return Description.NO_MATCH;
    }

    private Description describeMatchWithFix(Tree tree, VisitorState state) {
        return this.buildDescription(tree).addFix((Fix)SuggestedFixes.addSuppressWarnings((VisitorState)state, (String)this.canonicalName())).build();
    }

    private static boolean isDirectClassAccess(ExpressionTree expressionTree) {
        return expressionTree instanceof MemberSelectTree && ((MemberSelectTree)expressionTree).getIdentifier().contentEquals("class");
    }
}

