/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone.safety;

import com.google.common.collect.Multimap;
import com.google.errorprone.VisitorState;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.safety.Safety;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

public final class SafetyAnnotations {
    private static final String SAFE = "com.palantir.logsafe.Safe";
    private static final String UNSAFE = "com.palantir.logsafe.Unsafe";
    private static final String DO_NOT_LOG = "com.palantir.logsafe.DoNotLog";
    private static final TypeArgumentHandlers SAFETY_IS_COMBINATION_OF_TYPE_ARGUMENTS = new TypeArgumentHandlers(new TypeArgumentHandler(Iterable.class), new TypeArgumentHandler(Iterator.class), new TypeArgumentHandler(Map.class), new TypeArgumentHandler(Map.Entry.class), new TypeArgumentHandler(Multimap.class), new TypeArgumentHandler(Stream.class), new TypeArgumentHandler(Optional.class));

    public static Safety getSafety(Tree tree, VisitorState state) {
        Type type;
        Symbol treeSymbol = ASTHelpers.getSymbol((Tree)tree);
        Safety symbolSafety = SafetyAnnotations.getSafety(treeSymbol, state);
        Type type2 = type = tree instanceof ExpressionTree ? ASTHelpers.getResultType((ExpressionTree)((ExpressionTree)tree)) : ASTHelpers.getType((Tree)tree);
        if (type == null) {
            return symbolSafety;
        }
        return Safety.mergeAssumingUnknownIsSame(symbolSafety, SafetyAnnotations.getSafety(type, state), SafetyAnnotations.getSafety(type.tsym, state));
    }

    public static Safety getSafety(@Nullable Symbol symbol, VisitorState state) {
        if (symbol != null) {
            if (ASTHelpers.hasAnnotation((Symbol)symbol, (String)DO_NOT_LOG, (VisitorState)state)) {
                return Safety.DO_NOT_LOG;
            }
            if (ASTHelpers.hasAnnotation((Symbol)symbol, (String)UNSAFE, (VisitorState)state)) {
                return Safety.UNSAFE;
            }
            if (ASTHelpers.hasAnnotation((Symbol)symbol, (String)SAFE, (VisitorState)state)) {
                return Safety.SAFE;
            }
            if (symbol instanceof Symbol.MethodSymbol) {
                return SafetyAnnotations.getSuperMethodSafety((Symbol.MethodSymbol)symbol, state);
            }
            if (symbol instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                return SafetyAnnotations.getSuperMethodParameterSafety(varSymbol, state);
            }
        }
        return Safety.UNKNOWN;
    }

    public static Safety getSafety(@Nullable Type type, VisitorState state) {
        if (type != null) {
            return SafetyAnnotations.getSafetyInternal(type, state, null);
        }
        return Safety.UNKNOWN;
    }

    private static Safety getSafetyInternal(Type type, VisitorState state, Set<String> dejaVu) {
        java.util.List typeAnnotations = type.getAnnotationMirrors();
        for (Attribute.TypeCompound annotation : typeAnnotations) {
            TypeElement annotationElement = (TypeElement)annotation.getAnnotationType().asElement();
            Name name = annotationElement.getQualifiedName();
            if (name.contentEquals(DO_NOT_LOG)) {
                return Safety.DO_NOT_LOG;
            }
            if (name.contentEquals(UNSAFE)) {
                return Safety.UNSAFE;
            }
            if (!name.contentEquals(SAFE)) continue;
            return Safety.SAFE;
        }
        return SAFETY_IS_COMBINATION_OF_TYPE_ARGUMENTS.getSafety(type, state, dejaVu);
    }

    private static Safety getSuperMethodSafety(Symbol.MethodSymbol method, VisitorState state) {
        Safety safety = Safety.UNKNOWN;
        if (!method.isStaticOrInstanceInit()) {
            for (Symbol.MethodSymbol superMethod : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)method, (Types)state.getTypes())) {
                safety = Safety.mergeAssumingUnknownIsSame(safety, SafetyAnnotations.getSafety(superMethod, state));
            }
        }
        return safety;
    }

    private static Safety getSuperMethodParameterSafety(Symbol.VarSymbol varSymbol, VisitorState state) {
        Symbol.MethodSymbol method;
        Safety safety = Safety.UNKNOWN;
        if (varSymbol.owner instanceof Symbol.MethodSymbol && !(method = (Symbol.MethodSymbol)varSymbol.owner).isStaticOrInstanceInit()) {
            java.util.List methodParameters = method.getParameters();
            for (int i = 0; i < ((List)methodParameters).size(); ++i) {
                Symbol.VarSymbol current = (Symbol.VarSymbol)((List)methodParameters).get(i);
                if (!Objects.equals(current, varSymbol)) continue;
                for (Symbol.MethodSymbol superMethod : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)method, (Types)state.getTypes())) {
                    safety = Safety.mergeAssumingUnknownIsSame(safety, SafetyAnnotations.getSafety((Symbol)((List)superMethod.getParameters()).get(i), state));
                }
                return safety;
            }
        }
        return safety;
    }

    private SafetyAnnotations() {
    }

    private static final class TypeArgumentHandler {
        private final Supplier<Type> typeSupplier;

        TypeArgumentHandler(Class<?> clazz) {
            if (clazz.getTypeParameters().length == 0) {
                throw new IllegalStateException("Class " + clazz + " has no type parameters");
            }
            this.typeSupplier = Suppliers.typeFromClass(clazz);
        }

        private static Type unwrapWildcard(Type type) {
            Type.WildcardType wildcard;
            Type ext;
            if (type instanceof Type.WildcardType && (ext = (wildcard = (Type.WildcardType)type).getExtendsBound()) != null) {
                return ext;
            }
            return type;
        }

        @Nullable
        Safety getSafety(Type type, VisitorState state, @Nullable Set<String> dejaVu) {
            Type baseType = (Type)this.typeSupplier.get(state);
            if (ASTHelpers.isSubtype((Type)type, (Type)baseType, (VisitorState)state)) {
                String typeString;
                HashSet<String> deJaVuToPass = dejaVu == null ? new HashSet<String>() : dejaVu;
                if (!deJaVuToPass.add(typeString = type.toString())) {
                    return Safety.UNKNOWN;
                }
                Type asSubtype = state.getTypes().asSuper(TypeArgumentHandler.unwrapWildcard(type), baseType.tsym);
                if (asSubtype == null) {
                    return null;
                }
                Safety safety = Safety.SAFE;
                List<Type> typeArguments = asSubtype.getTypeArguments();
                for (Type typeArgument : typeArguments) {
                    Safety safetyBasedOnType = SafetyAnnotations.getSafetyInternal(typeArgument, state, deJaVuToPass);
                    Safety safetyBasedOnSymbol = SafetyAnnotations.getSafety(typeArgument.tsym, state);
                    Safety typeArgumentSafety = Safety.mergeAssumingUnknownIsSame(safetyBasedOnType, safetyBasedOnSymbol);
                    safety = (Safety)safety.leastUpperBound(typeArgumentSafety);
                }
                deJaVuToPass.remove(typeString);
                return safety;
            }
            return null;
        }
    }

    private static final class TypeArgumentHandlers {
        private final TypeArgumentHandler[] handlers;

        TypeArgumentHandlers(TypeArgumentHandler ... handlers) {
            this.handlers = handlers;
        }

        Safety getSafety(Type type, VisitorState state, @Nullable Set<String> dejaVu) {
            for (TypeArgumentHandler handler : this.handlers) {
                Safety result = handler.getSafety(type, state, dejaVu);
                if (result == null) continue;
                return result;
            }
            return Safety.UNKNOWN;
        }
    }
}

