/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import java.util.stream.BaseStream;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, summary="If a constructor or method returns an AutoCloseable, it should be annotated @MustBeClosed to ensure callers appropriately close resources")
@AutoService(value={BugChecker.class})
public final class AutoCloseableMustBeClosed
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String MUST_BE_CLOSED_TYPE = "com.google.errorprone.annotations.MustBeClosed";
    private static final String CAN_IGNORE_RETURN_VALUE_TYPE = "com.google.errorprone.annotations.CanIgnoreReturnValue";
    private static final Matcher<MethodTree> methodReturnsAutoCloseable = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.methodIsConstructor()), Matchers.methodReturns((Matcher)Matchers.isSubtypeOf(AutoCloseable.class)), Matchers.not((Matcher)Matchers.methodReturns((Matcher)Matchers.isSubtypeOf(BaseStream.class))), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.not((Matcher)OverrideMethod.INSTANCE), Matchers.hasAnnotationOnAnyOverriddenMethod((String)"com.google.errorprone.annotations.MustBeClosed")})});
    private static final Matcher<MethodTree> constructsAutoCloseable = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsConstructor(), Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf(AutoCloseable.class)), Matchers.not((Matcher)Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf(BaseStream.class)))});
    private static final Matcher<MethodTree> methodNotAnnotatedMustBeClosed = Matchers.not((Matcher)Matchers.hasAnnotation((String)"com.google.errorprone.annotations.MustBeClosed"));
    private static final Matcher<MethodTree> methodNotAnnotatedIgnoreReturnValue = Matchers.not((Matcher)Matchers.hasAnnotation((String)"com.google.errorprone.annotations.CanIgnoreReturnValue"));
    private static final Matcher<MethodTree> methodShouldBeAnnotatedMustBeClosed = Matchers.allOf((Matcher[])new Matcher[]{methodNotAnnotatedMustBeClosed, methodNotAnnotatedIgnoreReturnValue, Matchers.anyOf((Matcher[])new Matcher[]{methodReturnsAutoCloseable, constructsAutoCloseable})});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (methodShouldBeAnnotatedMustBeClosed.matches((Tree)tree, state)) {
            SuggestedFix.Builder builder = SuggestedFix.builder();
            String annotation = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (String)MUST_BE_CLOSED_TYPE);
            return this.buildDescription(tree).addFix((Fix)builder.prefixWith((Tree)tree, "@" + annotation + " ").build()).build();
        }
        return Description.NO_MATCH;
    }

    private static enum OverrideMethod implements Matcher<MethodTree>
    {
        INSTANCE;


        public boolean matches(MethodTree tree, VisitorState state) {
            Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodTree)tree);
            if (methodSym == null) {
                return false;
            }
            return !ASTHelpers.findSuperMethods((Symbol.MethodSymbol)methodSym, (Types)state.getTypes()).isEmpty();
        }
    }
}

