/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreeScanner;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="log statement in catch block does not log the caught exception.")
@AutoService(value={BugChecker.class})
public final class CatchBlockLogException
extends BugChecker
implements BugChecker.CatchTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> logMethod = MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"org.slf4j.Logger", "com.palantir.logsafe.logger.SafeLogger"}).withNameMatching(Pattern.compile("trace|debug|info|warn|error"));
    private static final Matcher<Tree> containslogMethod = Matchers.contains((Matcher)Matchers.toType(ExpressionTree.class, logMethod));
    private static final Matcher<ExpressionTree> logException = Matchers.methodInvocation(logMethod, (ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.LAST, MoreMatchers.isSubtypeOf(Throwable.class));
    private static final Matcher<Tree> containslogException = Matchers.contains((Matcher)Matchers.toType(ExpressionTree.class, logException));

    public Description matchCatch(CatchTree tree, VisitorState state) {
        if (containslogMethod.matches((Tree)tree, state) && !containslogException.matches((Tree)tree, state)) {
            return this.buildDescription(tree).addFix((Fix)CatchBlockLogException.attemptFix(tree, state)).setMessage("Catch block contains log statements but thrown exception is never logged.").build();
        }
        return Description.NO_MATCH;
    }

    private static SuggestedFix attemptFix(CatchTree tree, VisitorState state) {
        List<MethodInvocationTree> matchingLoggingStatements = tree.getBlock().accept(LogStatementScanner.INSTANCE, state);
        if (matchingLoggingStatements == null || matchingLoggingStatements.size() != 1) {
            return SuggestedFix.emptyFix();
        }
        MethodInvocationTree loggingInvocation = matchingLoggingStatements.get(0);
        if (containslogException.matches((Tree)loggingInvocation, state)) {
            return SuggestedFix.emptyFix();
        }
        List<? extends ExpressionTree> loggingArguments = loggingInvocation.getArguments();
        ExpressionTree lastArgument = loggingArguments.get(loggingArguments.size() - 1);
        return SuggestedFix.builder().replace((Tree)lastArgument, lastArgument.accept(ThrowableFromArgVisitor.INSTANCE, state).orElseGet(() -> state.getSourceForNode((Tree)lastArgument) + ", " + tree.getParameter().getName())).build();
    }

    private static final class LogStatementScanner
    extends TreeScanner<List<MethodInvocationTree>, VisitorState> {
        private static final LogStatementScanner INSTANCE = new LogStatementScanner();

        private LogStatementScanner() {
        }

        @Override
        public List<MethodInvocationTree> visitMethodInvocation(MethodInvocationTree node, VisitorState state) {
            if (logMethod.matches((Tree)node, state)) {
                return ImmutableList.of((Object)node);
            }
            return (List)super.visitMethodInvocation(node, state);
        }

        @Override
        public List<MethodInvocationTree> visitCatch(CatchTree node, VisitorState state) {
            return ImmutableList.of();
        }

        @Override
        public List<MethodInvocationTree> reduce(@Nullable List<MethodInvocationTree> left, @Nullable List<MethodInvocationTree> right) {
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            return ImmutableList.builder().addAll(left).addAll(right).build();
        }
    }

    private static final class ThrowableFromInvocationVisitor
    extends SimpleTreeVisitor<Optional<String>, VisitorState> {
        private static final ThrowableFromInvocationVisitor INSTANCE = new ThrowableFromInvocationVisitor();

        ThrowableFromInvocationVisitor() {
            super(Optional.empty());
        }

        @Override
        public Optional<String> visitMemberSelect(MemberSelectTree node, VisitorState state) {
            if (node.getIdentifier().contentEquals("getMessage")) {
                return Optional.ofNullable(state.getSourceForNode((Tree)node.getExpression()));
            }
            return Optional.empty();
        }
    }

    private static final class ThrowableFromArgVisitor
    extends SimpleTreeVisitor<Optional<String>, VisitorState> {
        private static final ThrowableFromArgVisitor INSTANCE = new ThrowableFromArgVisitor();
        private static final Matcher<ExpressionTree> throwableMessageInvocation = Matchers.instanceMethod().onDescendantOf(Throwable.class.getName()).named("getMessage");

        ThrowableFromArgVisitor() {
            super(Optional.empty());
        }

        @Override
        public Optional<String> visitMethodInvocation(MethodInvocationTree node, VisitorState state) {
            if (throwableMessageInvocation.matches((Tree)node, state)) {
                return node.getMethodSelect().accept(ThrowableFromInvocationVisitor.INSTANCE, state);
            }
            return Optional.empty();
        }
    }
}

