/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.MoreASTHelpers;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.element.Name;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Prefer more specific error types than Exception and Throwable. When methods are updated to throw new checked exceptions they expect callers to handle failure types explicitly. Catching broad types defeats the type system. By catching the most specific types possible we leverage existing compiler functionality to detect unreachable code.\nNote: Checked exceptions are only validated by the compiler and can be thrown by non-standard bytecode at runtime, for example when java code calls into groovy or scala generated bytecode a checked exception can be thrown despite not being declared. In these scenarios we recommend suppressing this check using @SuppressWarnings(\"CatchSpecificity\") and a comment describing the reason. Remaining instances can be automatically fixed using ./gradlew compileJava -PerrorProneApply=CatchSpecificity")
@AutoService(value={BugChecker.class})
public final class CatchSpecificity
extends BugChecker
implements BugChecker.TryTreeMatcher {
    private static final int MAX_CHECKED_EXCEPTIONS = 3;
    private static final Matcher<Tree> THROWABLE = Matchers.isSameType(Throwable.class);
    private static final Matcher<Tree> EXCEPTION = Matchers.isSameType(Exception.class);
    private static final ImmutableList<String> THROWABLE_REPLACEMENTS = ImmutableList.of((Object)RuntimeException.class.getName(), (Object)Error.class.getName());
    private static final ImmutableList<String> EXCEPTION_REPLACEMENTS = ImmutableList.of((Object)RuntimeException.class.getName());

    public Description matchTry(TryTree tree, VisitorState state) {
        ArrayList<Type> encounteredTypes = new ArrayList<Type>();
        for (CatchTree catchTree : tree.getCatches()) {
            Tree catchTypeTree = catchTree.getParameter().getType();
            Type catchType = ASTHelpers.getType((Tree)catchTypeTree);
            if (catchType == null) {
                return Description.NO_MATCH;
            }
            if (catchType.isUnion()) {
                encounteredTypes.addAll((Collection<Type>)MoreASTHelpers.expandUnion(catchType));
                continue;
            }
            boolean isException = EXCEPTION.matches(catchTypeTree, state);
            boolean isThrowable = THROWABLE.matches(catchTypeTree, state);
            if (isException || isThrowable) {
                ImmutableList<Type> thrown = MoreASTHelpers.flattenTypesForAssignment(CatchSpecificity.getThrownCheckedExceptions(tree, state), state);
                if (CatchSpecificity.containsBroadException(thrown, state)) {
                    return Description.NO_MATCH;
                }
                if (thrown.size() > 3 || TestCheckUtils.isTestCode(state)) {
                    return Description.NO_MATCH;
                }
                List<Type> replacements = CatchSpecificity.deduplicateCatchTypes((List<Type>)ImmutableList.builder().addAll(thrown).addAll((Iterable)(isThrowable ? THROWABLE_REPLACEMENTS : EXCEPTION_REPLACEMENTS).stream().map(name -> (Type)Preconditions.checkNotNull((Object)state.getTypeFromString(name), (Object)"Failed to find type")).collect(ImmutableList.toImmutableList())).build(), encounteredTypes, state);
                if (replacements.isEmpty()) {
                    state.reportMatch(this.buildDescription(catchTree).addFix((Fix)SuggestedFix.replace((Tree)catchTree, (String)"")).build());
                } else {
                    Name parameterName = catchTree.getParameter().getName();
                    AssignmentScanner assignmentScanner = new AssignmentScanner(parameterName);
                    catchTree.getBlock().accept(assignmentScanner, null);
                    SuggestedFix.Builder fix = SuggestedFix.builder();
                    if (replacements.size() == 1 || !assignmentScanner.variableWasAssigned) {
                        catchTree.accept(new ImpossibleConditionScanner(fix, replacements, parameterName), state);
                        fix.replace(catchTypeTree, replacements.stream().map(type -> SuggestedFixes.prettyType((VisitorState)state, (SuggestedFix.Builder)fix, (Type)type)).collect(Collectors.joining(" | ")));
                    }
                    state.reportMatch(this.buildDescription(catchTree).addFix((Fix)fix.build()).build());
                }
                encounteredTypes.addAll(replacements);
                continue;
            }
            encounteredTypes.add(catchType);
        }
        return Description.NO_MATCH;
    }

    private static List<Type> deduplicateCatchTypes(List<Type> proposedReplacements, List<Type> caughtTypes, VisitorState state) {
        ArrayList<Type> replacements = new ArrayList<Type>();
        for (Type replacementType : proposedReplacements) {
            if (!caughtTypes.stream().noneMatch(alreadyCaught -> state.getTypes().isSubtype(replacementType, (Type)alreadyCaught))) continue;
            replacements.add(replacementType);
        }
        return replacements;
    }

    private static ImmutableList<Type> getThrownCheckedExceptions(TryTree tree, VisitorState state) {
        return (ImmutableList)MoreASTHelpers.getThrownExceptionsFromTryBody(tree, state).stream().filter(type -> ASTHelpers.isCheckedExceptionType((Type)type, (VisitorState)state)).collect(ImmutableList.toImmutableList());
    }

    private static boolean containsBroadException(Collection<Type> exceptions, VisitorState state) {
        return exceptions.stream().anyMatch(type -> CatchSpecificity.isBroadException(type, state));
    }

    private static boolean isBroadException(Type type, VisitorState state) {
        return ASTHelpers.isSameType((Type)state.getTypeFromString(Exception.class.getName()), (Type)type, (VisitorState)state) || ASTHelpers.isSameType((Type)state.getTypeFromString(Throwable.class.getName()), (Type)type, (VisitorState)state);
    }

    private static final class AssignmentScanner
    extends TreeScanner<Void, Void> {
        private final Name exceptionName;
        private boolean variableWasAssigned;

        AssignmentScanner(Name exceptionName) {
            this.exceptionName = exceptionName;
        }

        @Override
        public Void visitAssignment(AssignmentTree node, Void state) {
            ExpressionTree expression = node.getVariable();
            if (expression instanceof IdentifierTree && ((IdentifierTree)expression).getName().contentEquals(this.exceptionName)) {
                this.variableWasAssigned = true;
            }
            return (Void)super.visitAssignment(node, state);
        }

        @Override
        public Void visitLambdaExpression(LambdaExpressionTree node, Void state) {
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree var1, Void state) {
            return null;
        }
    }

    private static final class ImpossibleConditionScanner
    extends TreeScanner<Void, VisitorState> {
        private final SuggestedFix.Builder fix;
        private final List<Type> caughtTypes;
        private final Name exceptionName;

        ImpossibleConditionScanner(SuggestedFix.Builder fix, List<Type> caughtTypes, Name exceptionName) {
            this.fix = fix;
            this.caughtTypes = caughtTypes;
            this.exceptionName = exceptionName;
        }

        @Override
        public Void visitIf(final IfTree node, final VisitorState state) {
            return node.getCondition().accept(new SimpleTreeVisitor<Void, Void>(){

                @Override
                public Void visitInstanceOf(InstanceOfTree instanceOfNode, Void ignored) {
                    if (!this.matchesInstanceOf(instanceOfNode, state)) {
                        return null;
                    }
                    if (node.getElseStatement() == null) {
                        fix.replace((Tree)node, "");
                    } else {
                        fix.replace((Tree)node, ImpossibleConditionScanner.unwrapBlock(node.getElseStatement(), state));
                    }
                    return null;
                }

                @Override
                public Void visitParenthesized(ParenthesizedTree node2, Void ignored) {
                    return node2.getExpression().accept(this, ignored);
                }
            }, null);
        }

        @Override
        public Void visitInstanceOf(InstanceOfTree node, VisitorState state) {
            if (this.matchesInstanceOf(node, state)) {
                this.fix.replace((Tree)node, "false");
            }
            return null;
        }

        private boolean matchesInstanceOf(InstanceOfTree instanceOfNode, VisitorState state) {
            ExpressionTree expression = instanceOfNode.getExpression();
            return expression instanceof IdentifierTree && ((IdentifierTree)expression).getName().contentEquals(this.exceptionName) && !this.isTypeValid(ASTHelpers.getType((Tree)instanceOfNode.getType()), state);
        }

        @Override
        public Void visitLambdaExpression(LambdaExpressionTree node, VisitorState state) {
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree var1, VisitorState state) {
            return null;
        }

        private boolean isTypeValid(Type instanceOfTarget, VisitorState state) {
            return this.caughtTypes.stream().anyMatch(caught -> state.getTypes().isCastable((Type)caught, instanceOfTarget));
        }

        @Nullable
        private static String unwrapBlock(StatementTree statement, VisitorState state) {
            if (statement.getKind() == Tree.Kind.BLOCK) {
                CharSequence source = state.getSourceCode();
                if (source == null) {
                    return null;
                }
                BlockTree blockStatement = (BlockTree)statement;
                List<? extends StatementTree> statements = blockStatement.getStatements();
                if (statements.isEmpty()) {
                    return "";
                }
                int startPosition = ((JCTree)((Object)statements.get(0))).getStartPosition();
                int endPosition = state.getEndPosition((Tree)statements.get(statements.size() - 1));
                return source.subSequence(startPosition, endPosition).toString();
            }
            return state.getSourceForNode((Tree)statement);
        }
    }
}

