/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Stream;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Collection.forEach is more efficient than Collection.stream().forEach")
@AutoService(value={BugChecker.class})
public final class CollectionStreamForEach
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> STREAM_FOR_EACH = MethodMatchers.instanceMethod().onDescendantOf(Stream.class.getName()).namedAnyOf(new String[]{"forEach", "forEachOrdered"}).withParameters(Consumer.class.getName(), new String[0]);
    private static final Matcher<ExpressionTree> COLLECTION_STREAM = MethodMatchers.instanceMethod().onDescendantOf(Collection.class.getName()).named("stream").withNoParameters();
    private static final Matcher<MethodInvocationTree> matcher = Matchers.allOf((Matcher[])new Matcher[]{STREAM_FOR_EACH, Matchers.receiverOfInvocation(COLLECTION_STREAM)});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (matcher.matches((Tree)tree, state)) {
            ExpressionTree stream = ASTHelpers.getReceiver((ExpressionTree)tree);
            if (stream == null) {
                return this.describeMatch(tree);
            }
            ExpressionTree collection = ASTHelpers.getReceiver((ExpressionTree)stream);
            if (collection == null) {
                return this.describeMatch(tree);
            }
            return this.buildDescription(tree).addFix((Fix)SuggestedFix.builder().merge(SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"forEach", (VisitorState)state)).replace((Tree)stream, state.getSourceForNode((Tree)collection)).build()).build();
        }
        return Description.NO_MATCH;
    }
}

