/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.AnnotationHasArgumentWithValue;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.io.Serializable;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Disallow usage of Jackson's Type Information features for security reasons, cf. https://github.com/FasterXML/jackson-databind/issues/1599")
@AutoService(value={BugChecker.class})
public final class DangerousJsonTypeInfoUsage
extends BugChecker
implements BugChecker.AnnotationTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<AnnotationTree> annotationMatcher = new AnnotationHasArgumentWithValue("use", Matchers.allOf((Matcher[])new Matcher[]{Matchers.isSameType((String)"com.fasterxml.jackson.annotation.JsonTypeInfo$Id"), Matchers.anyOf((Matcher[])new Matcher[]{DangerousJsonTypeInfoUsage.symbolNamed("CLASS"), DangerousJsonTypeInfoUsage.symbolNamed("MINIMAL_CLASS")})}));
    private static final Matcher<ExpressionTree> objectMapperTypeInfoMatcher = MethodMatchers.instanceMethod().onDescendantOf("com.fasterxml.jackson.databind.ObjectMapper").namedAnyOf(new String[]{"enableDefaultTyping", "enableDefaultTypingAsProperty", "activateDefaultTyping", "activateDefaultTypingAsProperty", "setDefaultTyping"});

    private static Matcher<ExpressionTree> symbolNamed(String value) {
        return (Matcher & Serializable)(expressionTree, state) -> {
            Symbol symbol = ASTHelpers.getSymbol((Tree)expressionTree);
            return symbol != null && symbol.name.contentEquals(value);
        };
    }

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        if (!annotationMatcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Must not use Jackson @JsonTypeInfo annotation with JsonTypeInfo.Id.CLASS or JsonTypeInfo.Id.MINIMAL_CLASS").build();
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!objectMapperTypeInfoMatcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Must not use a Jackson ObjectMapper with default typings because it may allow remote code execution upon deserialization. Additionally, using java types in API makes usage more difficult for consumers using other languages.").build();
    }
}

