/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.FilterOutputStream;
import java.io.Serializable;
import javax.lang.model.element.ElementKind;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, summary="Please also override `void write(byte[], int, int)`, otherwise multi-byte writes to this output stream are likely to be slow.", severity=BugPattern.SeverityLevel.WARNING, tags={"Performance"})
@AutoService(value={BugChecker.class})
public final class FilterOutputStreamSlowMultibyteWrite
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> IS_FILTER_OUTPUT_STREAM = Matchers.isSubtypeOf(FilterOutputStream.class);
    private static final Matcher<MethodTree> WRITE_INT_METHOD = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"write"), Matchers.methodReturns((Supplier)Suppliers.VOID_TYPE), Matchers.methodHasParameters((Matcher[])new Matcher[]{Matchers.isSameType((Supplier)Suppliers.INT_TYPE)})});
    private static final Supplier<Name> WRITE = VisitorState.memoize((Supplier & Serializable)state -> state.getName("write"));
    private static final Supplier<Type> FILTER_OUTPUT_STREAM = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString(FilterOutputStream.class.getTypeName()));

    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!IS_FILTER_OUTPUT_STREAM.matches((Tree)classTree, state)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol thisClassSymbol = ASTHelpers.getSymbol((ClassTree)classTree);
        if (((Symbol)thisClassSymbol).getKind() != ElementKind.CLASS) {
            return Description.NO_MATCH;
        }
        Type.JCPrimitiveType intType = state.getSymtab().intType;
        Symbol.MethodSymbol singleByteWriteMethod = ASTHelpers.resolveExistingMethod((VisitorState)state, (Symbol.TypeSymbol)thisClassSymbol, (Name)((Name)WRITE.get(state)), (Iterable)ImmutableList.of((Object)intType), (Iterable)ImmutableList.of());
        if (singleByteWriteMethod == null) {
            return Description.NO_MATCH;
        }
        Type filterOutputStreamType = (Type)FILTER_OUTPUT_STREAM.get(state);
        if (filterOutputStreamType == null) {
            return Description.NO_MATCH;
        }
        Type byteArrayType = state.arrayTypeForType((Type)state.getSymtab().byteType);
        Symbol.MethodSymbol multiByteWriteMethod = ASTHelpers.resolveExistingMethod((VisitorState)state, (Symbol.TypeSymbol)thisClassSymbol, (Name)((Name)WRITE.get(state)), (Iterable)ImmutableList.of((Object)byteArrayType, (Object)intType, (Object)intType), (Iterable)ImmutableList.of());
        if (multiByteWriteMethod != null && (multiByteWriteMethod.owner.equals(thisClassSymbol) || singleByteWriteMethod.owner.equals(multiByteWriteMethod.owner) && !singleByteWriteMethod.owner.equals(filterOutputStreamType.tsym))) {
            return Description.NO_MATCH;
        }
        MethodTree writeByteMethod = classTree.getMembers().stream().filter(MethodTree.class::isInstance).map(MethodTree.class::cast).filter(m -> WRITE_INT_METHOD.matches((Tree)m, state)).findFirst().orElse(null);
        return writeByteMethod == null ? this.describeMatch(classTree) : this.describeMatch(writeByteMethod);
    }
}

