/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.SymbolPredicates;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.function.Predicate;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Supplying an object which uses legacy javax types, such as javax.ws.rs to a\nmethod which requires newer jakarta types is a runtime error. This check ensures\nthat you only supply proper types to these methods which generally just take an\nuntyped Object. There is no auto-fix for this check, you must fix it manually")
@AutoService(value={BugChecker.class})
public final class ForbidJavaxParameterType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String FORBID_JAVAX_TYPE = "com.palantir.errorprone.ForbidJavax";
    private static final Predicate<Symbol> HAS_JAXRS_ANNOTATION = SymbolPredicates.hasAnnotationWithPackage("javax.ws.rs");
    private static final TypePredicate IMPLEMENTS_FEATURE = TypePredicates.isDescendantOf((String)"javax.ws.rs.core.Feature");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> arguments = tree.getArguments();
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        List methodParameters = methodSymbol.getParameters();
        if (methodParameters == null || methodParameters.isEmpty() || arguments == null || arguments.isEmpty() || arguments.size() != methodParameters.size()) {
            return Description.NO_MATCH;
        }
        for (int i = 0; i < methodParameters.size(); ++i) {
            Type resultType;
            Symbol.VarSymbol parameter = (Symbol.VarSymbol)methodParameters.get(i);
            ExpressionTree argument = arguments.get(i);
            boolean missingForbidJavaAnnotation = parameter.getAnnotationMirrors().stream().noneMatch(c -> FORBID_JAVAX_TYPE.equals(c.type.tsym.flatName().toString()));
            if (missingForbidJavaAnnotation || !this.hasJavaxInclusions(resultType = ASTHelpers.getResultType((ExpressionTree)argument), state)) continue;
            return this.buildDescription(tree).setMessage(resultType.asElement().getQualifiedName().toString() + " registers legacy javax imports but is being supplied to a method which requires jakarta").build();
        }
        return Description.NO_MATCH;
    }

    private boolean hasJavaxInclusions(Type resultType, VisitorState state) {
        if (resultType == null) {
            return false;
        }
        return this.hasJavaxInclusionsOnType(resultType.asElement(), state);
    }

    private boolean hasJavaxInclusionsOnType(Symbol.TypeSymbol symbol, VisitorState state) {
        if (symbol instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol classType = (Symbol.ClassSymbol)symbol;
            if (IMPLEMENTS_FEATURE.apply(classType.type, state)) {
                return true;
            }
            if (HAS_JAXRS_ANNOTATION.test(classType)) {
                return true;
            }
            ImmutableList thisAndParents = ImmutableList.builder().add((Object)classType.type).addAll((Iterable)classType.getInterfaces()).build();
            for (Type t : thisAndParents) {
                for (Symbol sym : t.tsym.getEnclosedElements()) {
                    if (!HAS_JAXRS_ANNOTATION.test(sym)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

