/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(severity=BugPattern.SeverityLevel.ERROR, summary="You should avoid using incubating methods where possible, since they have very weak stability guarantees. You can explicitly disable this check on a case-by-case basis using @SuppressWarnings(\"IncubatingMethod\").")
@AutoService(value={BugChecker.class})
public final class IncubatingMethod
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final Matcher<Tree> INCUBATING_MATCHER = Matchers.symbolHasAnnotation((String)"com.palantir.conjure.java.lib.internal.Incubating");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.checkTree(tree, state);
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        return this.checkTree(tree, state);
    }

    private Description checkTree(Tree tree, VisitorState state) {
        if (!INCUBATING_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        if (TestCheckUtils.isTestCode(state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

