/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.StreamResourceLeak;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Methods that return an autocloseable resource on jOOQ's ResultQuery should be closed using try-with-resources. Not doing so can result in leaked database resources (such as connections or cursors) in code paths that throw an exception or fail to call #close().")
@AutoService(value={BugChecker.class})
public final class JooqResultStreamLeak
extends StreamResourceLeak {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("org.jooq.ResultQuery").withAnyName(), JooqResultStreamLeak::shouldBeAutoClosed});
    private static final Supplier<Type> JOOQ_QUERY_PART = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("org.jooq.QueryPart"));
    private static final Supplier<Type> AUTO_CLOSEABLE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString(AutoCloseable.class.getName()));

    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.scanEntireMethodFor(MATCHER, tree, state);
    }

    private static boolean shouldBeAutoClosed(ExpressionTree tree, VisitorState state) {
        Type returnType = ASTHelpers.getReturnType((ExpressionTree)tree);
        boolean isAutoCloseable = ASTHelpers.isSubtype((Type)returnType, (Type)((Type)AUTO_CLOSEABLE.get(state)), (VisitorState)state);
        boolean isJooqQuery = ASTHelpers.isSubtype((Type)returnType, (Type)((Type)JOOQ_QUERY_PART.get(state)), (VisitorState)state);
        return isAutoCloseable && !isJooqQuery;
    }
}

