/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Logger call interpolation markers should not be used for the throwable parameter because they prevent stack traces from being logged in favor of the string value of the Throwable.")
@AutoService(value={BugChecker.class})
public final class LoggerInterpolationConsumesThrowable
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> LOG_METHOD = MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"org.slf4j.Logger", "com.palantir.logsafe.logger.SafeLogger"}).namedAnyOf(new String[]{"trace", "debug", "info", "warn", "error", "fatal"});
    private static final Matcher<ExpressionTree> MARKER = MoreMatchers.isSubtypeOf("org.slf4j.Marker");
    private static final Matcher<ExpressionTree> THROWABLE = MoreMatchers.isSubtypeOf(Throwable.class);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        int nonThrowableParameters;
        if (!LOG_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = tree.getArguments();
        if (args.size() <= 1) {
            return Description.NO_MATCH;
        }
        int throwableIndex = args.size() - 1;
        ExpressionTree lastArg = args.get(throwableIndex);
        if (!THROWABLE.matches((Tree)lastArg, state)) {
            return Description.NO_MATCH;
        }
        boolean hasMarker = MARKER.matches((Tree)tree.getArguments().get(0), state);
        int messageIndex = hasMarker ? 1 : 0;
        ExpressionTree messageArg = args.get(messageIndex);
        if (messageArg.getKind() != Tree.Kind.STRING_LITERAL) {
            return Description.NO_MATCH;
        }
        String literalMessage = (String)((LiteralTree)messageArg).getValue();
        int stringPlaceholders = this.countPlaceholders(literalMessage);
        if (stringPlaceholders <= (nonThrowableParameters = throwableIndex - messageIndex - 1)) {
            return Description.NO_MATCH;
        }
        int extraPlaceholders = stringPlaceholders - nonThrowableParameters;
        return this.buildDescription(tree).setMessage(String.format("Please remove %d '{}' placeholder%s. Logging statement contains %d placeholders for %d parameters. The Throwable will be consumed as a parameter (string value) rather than producing a stack trace.", extraPlaceholders, extraPlaceholders == 1 ? "" : "s", stringPlaceholders, nonThrowableParameters)).build();
    }

    private int countPlaceholders(String formatString) {
        int placeholders = 0;
        int index = 0;
        while ((index = formatString.indexOf("{}", index)) >= 0) {
            ++index;
            ++placeholders;
        }
        return placeholders;
    }
}

