/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.palantir.baseline.errorprone.safety.Safety;
import com.palantir.baseline.errorprone.safety.SafetyAnalysis;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.List;
import java.util.Objects;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="@DoNotLog types must not be passed to any logger directly or indirectly, for example respectively: log.info(doNotLog) or throw new RuntimeException(doNotLog.toString()). Exceptions are almost always passed to a logger in some form, and must not include data that cannot be logged.")
@AutoService(value={BugChecker.class})
public final class LoggingDoNotLog
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> THROWABLE_CTOR = MethodMatchers.constructor().forClass(TypePredicates.allOf((TypePredicate[])new TypePredicate[]{TypePredicates.isDescendantOf((String)Throwable.class.getName()), TypePredicates.not((TypePredicate)TypePredicates.isDescendantOf((String)"com.palantir.logsafe.SafeLoggable"))}));
    private static final Matcher<ExpressionTree> LOGGING_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger"), MethodMatchers.instanceMethod().onDescendantOf("org.apache.log4j.Logger"), MethodMatchers.instanceMethod().onDescendantOf("org.apache.logging.log4j.Logger"), MethodMatchers.instanceMethod().onDescendantOf(System.Logger.class.getName()).named("log"), MethodMatchers.instanceMethod().onDescendantOf("java.util.logging.Logger"), MethodMatchers.staticMethod().onClass("org.slf4j.MDC"), MethodMatchers.staticMethod().onClass("org.apache.log4j.MDC"), MethodMatchers.staticMethod().onClass("org.apache.logging.log4j.ThreadContext")});
    private static final Matcher<ExpressionTree> PRECONDITIONS_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.base.Preconditions").namedAnyOf(new String[]{"checkArgument", "checkNotNull", "checkState"}), MethodMatchers.staticMethod().onClass(Objects.class.getName()).named("requireNonNull").withParameters(Object.class.getName(), new String[]{String.class.getName()}), MethodMatchers.staticMethod().onClass("org.apache.commons.lang3.Validate").namedAnyOf(new String[]{"isTrue", "notNull", "validState"})});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.isEmpty()) {
            return Description.NO_MATCH;
        }
        if (LOGGING_METHODS.matches((Tree)tree, state)) {
            this.checkArguments(arguments, state, 0);
        }
        if (arguments.size() > 1 && PRECONDITIONS_METHODS.matches((Tree)tree, state)) {
            this.checkArguments(arguments, state, 1);
        }
        return Description.NO_MATCH;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!tree.getArguments().isEmpty() && THROWABLE_CTOR.matches((Tree)tree, state)) {
            this.checkArguments(tree.getArguments(), state, 0);
        }
        return Description.NO_MATCH;
    }

    private void checkArguments(List<? extends ExpressionTree> arguments, VisitorState state, int beginIndex) {
        for (int i = beginIndex; i < arguments.size(); ++i) {
            ExpressionTree argument = arguments.get(i);
            Safety argumentSafety = SafetyAnalysis.of(state.withPath(new TreePath(state.getPath(), argument)));
            if (argumentSafety != Safety.DO_NOT_LOG) continue;
            state.reportMatch(this.describeMatch(argument));
        }
    }
}

