/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.Map;
import java.util.Objects;

@BugPattern(summary="Prefer the common version of annotations over other copies.", severity=BugPattern.SeverityLevel.SUGGESTION)
@AutoService(value={BugChecker.class})
public final class PreferCommonAnnotations
extends BugChecker
implements BugChecker.ImportTreeMatcher {
    private static final Map<String, String> PREFERRED_IMPORTS = Map.of("VisibleForTesting", "com.google.common.annotations.VisibleForTesting");

    public Description matchImport(ImportTree tree, VisitorState state) {
        Type importType = ASTHelpers.getType((Tree)tree.getQualifiedIdentifier());
        if (importType == null) {
            return Description.NO_MATCH;
        }
        String importName = importType.toString();
        for (Map.Entry<String, String> entry : PREFERRED_IMPORTS.entrySet()) {
            String affectedClassName = entry.getKey();
            String preferredType = entry.getValue();
            if (!importName.endsWith(affectedClassName) || Objects.equals(importName, preferredType)) continue;
            SuggestedFix fix = SuggestedFix.builder().removeImport(importName).addImport(preferredType).build();
            return this.describeMatch(tree, (Fix)fix);
        }
        return Description.NO_MATCH;
    }
}

