/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.stream.Stream;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Authentication token information should never be logged as it poses a security risk. Prevents AuthHeader and BearerToken information from being passed to common logging calls.")
@AutoService(value={BugChecker.class})
public final class PreventTokenLogging
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableList<String> TOKEN_TYPES = ImmutableList.of((Object)"com.palantir.tokens.auth.AuthHeader", (Object)"com.palantir.tokens.auth.BearerToken");
    private static final Matcher<ExpressionTree> METHOD_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger"), MethodMatchers.staticMethod().onClassAny(new String[]{"com.palantir.logsafe.SafeArg", "com.palantir.logsafe.UnsafeArg"}).named("of")});
    private static final Matcher<ExpressionTree> AUTH_MATCHER = Matchers.anyOf((Iterable)((Iterable)TOKEN_TYPES.stream().flatMap(PreventTokenLogging::getMatchersForTokenType).collect(ImmutableList.toImmutableList())));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (METHOD_MATCHER.matches((Tree)tree, state)) {
            for (ExpressionTree expressionTree : tree.getArguments()) {
                if (!AUTH_MATCHER.matches((Tree)expressionTree, state)) continue;
                return this.buildDescription(expressionTree).setMessage("Authentication information is not allowed to be logged.").build();
            }
        }
        return Description.NO_MATCH;
    }

    private static Stream<Matcher<ExpressionTree>> getMatchersForTokenType(String tokenType) {
        return Stream.of(MoreMatchers.isSubtypeOf(tokenType), MethodMatchers.instanceMethod().onDescendantOf(tokenType));
    }
}

