/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="StringBuilder with a constant number of parameters should be replaced by simple concatenation")
@AutoService(value={BugChecker.class})
public final class StringBuilderConstantParameters
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String MESSAGE = "StringBuilder with a constant number of parameters should be replaced by simple concatenation.\nThe Java compiler (jdk8) replaces concatenation of a constant number of arguments with a StringBuilder, while jdk 9+ take advantage of JEP 280 (https://openjdk.java.net/jeps/280) to efficiently pre-size the result for better performance than a StringBuilder.";
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> STRING_BUILDER_TYPE_MATCHER = Matchers.isSameType(StringBuilder.class);
    private static final Matcher<ExpressionTree> STRING_BUILDER_TO_STRING = MethodMatchers.instanceMethod().onExactClass(StringBuilder.class.getName()).named("toString").withNoParameters();
    private static final Supplier<Type> JAVA_STRING = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.String"));
    private static final Supplier<Type> JAVA_CHARSEQUENCE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.CharSequence"));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!STRING_BUILDER_TO_STRING.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Optional<List<ExpressionTree>> result = tree.getMethodSelect().accept(StringBuilderVisitor.INSTANCE, state);
        if (!result.isPresent()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.containsComments((Tree)tree, (VisitorState)state)) {
            return this.buildDescription(tree).setMessage(MESSAGE).build();
        }
        List<ExpressionTree> arguments = result.get();
        Stream prefixStream = arguments.stream().findFirst().map(ASTHelpers::getType).filter(type -> ASTHelpers.isSameType((Type)type, (Type)((Type)JAVA_STRING.get(state)), (VisitorState)state)).map(ignored -> Stream.empty()).orElseGet(() -> Stream.of("\"\""));
        return this.buildDescription(tree).setMessage(MESSAGE).addFix((Fix)SuggestedFix.builder().replace((Tree)tree, Streams.concat((Stream[])new Stream[]{prefixStream, arguments.stream().map(node -> StringBuilderConstantParameters.getArgumentSourceString(state, node))}).collect(Collectors.joining(" + "))).build()).build();
    }

    private static String getArgumentSourceString(VisitorState state, ExpressionTree tree) {
        String originalSource = state.getSourceForNode((Tree)tree);
        if (tree instanceof ConditionalExpressionTree || tree instanceof BinaryTree) {
            return "(" + originalSource + ")";
        }
        return originalSource;
    }

    private static final class StringBuilderVisitor
    extends SimpleTreeVisitor<Optional<List<ExpressionTree>>, VisitorState> {
        private static final StringBuilderVisitor INSTANCE = new StringBuilderVisitor();

        private StringBuilderVisitor() {
            super(Optional.empty());
        }

        @Override
        public Optional<List<ExpressionTree>> visitNewClass(NewClassTree node, VisitorState state) {
            if (!STRING_BUILDER_TYPE_MATCHER.matches((Tree)node.getIdentifier(), state)) {
                return (Optional)this.defaultAction(node, state);
            }
            if (node.getArguments().isEmpty()) {
                return Optional.of(new ArrayList());
            }
            if (node.getArguments().size() == 1 && (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)node.getArguments().get(0)), (Type)((Type)JAVA_STRING.get(state)), (VisitorState)state) || ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)node.getArguments().get(0)), (Type)((Type)JAVA_CHARSEQUENCE.get(state)), (VisitorState)state))) {
                ArrayList<ExpressionTree> resultList = new ArrayList<ExpressionTree>();
                resultList.add(node.getArguments().get(0));
                return Optional.of(resultList);
            }
            return Optional.empty();
        }

        @Override
        public Optional<List<ExpressionTree>> visitMemberSelect(MemberSelectTree node, VisitorState state) {
            if (node.getIdentifier().contentEquals("append") || node.getIdentifier().contentEquals("toString")) {
                return node.getExpression().accept(this, state);
            }
            return (Optional)this.defaultAction(node, state);
        }

        @Override
        public Optional<List<ExpressionTree>> visitMethodInvocation(MethodInvocationTree node, VisitorState state) {
            Optional<List<ExpressionTree>> result = node.getMethodSelect().accept(this, state);
            if (result.isPresent()) {
                Preconditions.checkState((node.getArguments().size() == 1 ? 1 : 0) != 0, (Object)"Expected a single argument to 'append'");
                result.get().add(node.getArguments().get(0));
            }
            return result;
        }
    }
}

