/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.util.concurrent.RateLimiter;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="RateLimiters with zero warmup duration do not rate limit. Tracked at https://github.com/google/guava/issues/2730")
@AutoService(value={BugChecker.class})
public final class ZeroWarmupRateLimiter
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> DURATION_ZERO_MATCHER = Matchers.methodInvocation((Matcher)MethodMatchers.staticMethod().onClass(RateLimiter.class.getName()).named("create").withParameters("double", new String[]{Duration.class.getName()}), (ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.LAST, ZeroWarmupRateLimiter::isDurationZero);
    private static final Matcher<MethodInvocationTree> INT_LITERAL_ZERO_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass(RateLimiter.class.getName()).named("create").withParameters("double", new String[]{"long", TimeUnit.class.getName()}), Matchers.argument((int)1, ZeroWarmupRateLimiter::isIntLiteralZero)});
    private static final Matcher<MethodInvocationTree> MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{DURATION_ZERO_MATCHER, INT_LITERAL_ZERO_MATCHER});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> args = tree.getArguments();
        if (MATCHER.matches((Tree)tree, state)) {
            return this.buildDescription(tree).addFix((Fix)SuggestedFix.replace((int)state.getEndPosition((Tree)args.get(0)), (int)state.getEndPosition((Tree)args.get(args.size() - 1)), (String)"")).build();
        }
        return Description.NO_MATCH;
    }

    private static boolean isDurationZero(ExpressionTree expressionTree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)expressionTree);
        if (symbol != null && ASTHelpers.isStatic((Symbol)symbol) && symbol instanceof Symbol.VarSymbol) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
            return varSymbol.name.contentEquals("ZERO") && state.getTypes().isSameType(varSymbol.owner.type, state.getTypeFromString(Duration.class.getName()));
        }
        return false;
    }

    private static boolean isIntLiteralZero(ExpressionTree expressionTree, VisitorState state) {
        Number warmupTime = (Number)ASTHelpers.constValue((Tree)expressionTree, Number.class);
        return warmupTime != null && (warmupTime.equals(0) || warmupTime.equals(0L));
    }
}

