/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="AssertNoArgs", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Prefer hasNoArgs when asserting that an exception has no args.")
@AutoService(value={BugChecker.class})
public final class AssertNoArgs
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.instanceMethod().onExactClassAny(new String[]{"com.palantir.conjure.java.api.testing.ServiceExceptionAssert", "com.palantir.logsafe.testing.LoggableExceptionAssert"}).namedAnyOf(new String[]{"containsArgs", "hasArgs", "hasExactlyArgs"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (!tree.getArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"hasNoArgs", (VisitorState)state)).build();
    }
}

