/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.common.base.Preconditions;
import com.google.errorprone.util.RuntimeVersion;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.function.Predicate;

public final class BaselineErrorProneScope {
    private static final Class<?> FILTER_CLASS = BaselineErrorProneScope.getFilterClass();
    private static final Method getSymbols = BaselineErrorProneScope.getImpl("getSymbols", Predicate.class, Scope.LookupKind.class);
    private final Scope scope;

    public Iterable<Symbol> getSymbols(Predicate<Symbol> predicate, Scope.LookupKind lookupKind) {
        return (Iterable)this.invoke(getSymbols, new Object[]{this.maybeAsFilter(predicate), lookupKind});
    }

    private static Class<?> getFilterClass() {
        if (RuntimeVersion.isAtLeast17()) {
            return null;
        }
        try {
            return Class.forName("com.sun.tools.javac.util.Filter");
        }
        catch (ClassNotFoundException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static Method getImpl(String name, Class<?> ... parameters) {
        return FILTER_CLASS != null ? BaselineErrorProneScope.getMethodOrDie(Scope.class, name, (Class[])Arrays.stream(parameters).map(p -> p.equals(Predicate.class) ? FILTER_CLASS : p).toArray(Class[]::new)) : BaselineErrorProneScope.getMethodOrDie(Scope.class, name, parameters);
    }

    BaselineErrorProneScope(Scope scope) {
        this.scope = scope;
    }

    private Object invoke(Method method, Object ... args) {
        try {
            return method.invoke((Object)this.scope, args);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private Object maybeAsFilter(final Predicate<Symbol> predicate) {
        if (FILTER_CLASS == null) {
            return predicate;
        }
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{FILTER_CLASS}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                Preconditions.checkState((boolean)method.getName().equals("accepts"));
                return predicate.test((Symbol)args[0]);
            }
        });
    }

    private static Method getMethodOrDie(Class<?> clazz, String name, Class<?> ... parameters) {
        try {
            return clazz.getMethod(name, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }
}

