/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.PreconditionsMessageFormat;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import java.util.regex.Pattern;

@BugPattern(name="GuavaPreconditionsMessageFormat", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Guava Preconditions.checkX() methods must use print-f style formatting.")
@AutoService(value={BugChecker.class})
public final class GuavaPreconditionsMessageFormat
extends PreconditionsMessageFormat {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> GUAVA_PRECONDITIONS_METHODS = MethodMatchers.staticMethod().onClassAny(new String[]{"com.google.common.base.Preconditions"}).withNameMatching(Pattern.compile("checkArgument|checkState|checkNotNull"));

    public GuavaPreconditionsMessageFormat() {
        super(GUAVA_PRECONDITIONS_METHODS);
    }

    @Override
    protected Description matchMessageFormat(MethodInvocationTree tree, String message, VisitorState state) {
        if (!message.contains("{}")) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Use printf-style formatting in Guava Preconditions, not '{}' style formatting.").build();
    }
}

