/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.baseline.errorprone.ConsistentOverrides;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConsistentOverrides.ParamEntry", generator="Immutables")
@Immutable
final class ImmutableParamEntry
implements ConsistentOverrides.ParamEntry {
    private final Type type;
    private final String name;
    private final int index;

    private ImmutableParamEntry(Type type, String name, int index) {
        this.type = type;
        this.name = name;
        this.index = index;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int index() {
        return this.index;
    }

    public final ImmutableParamEntry withType(Type value) {
        if (this.type == value) {
            return this;
        }
        Type newValue = Objects.requireNonNull(value, "type");
        return new ImmutableParamEntry(newValue, this.name, this.index);
    }

    public final ImmutableParamEntry withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableParamEntry(this.type, newValue, this.index);
    }

    public final ImmutableParamEntry withIndex(int value) {
        if (this.index == value) {
            return this;
        }
        return new ImmutableParamEntry(this.type, this.name, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParamEntry && this.equalTo((ImmutableParamEntry)another);
    }

    private boolean equalTo(ImmutableParamEntry another) {
        return this.type.equals(another.type) && this.name.equals(another.name) && this.index == another.index;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.index;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ParamEntry").omitNullValues().add("type", (Object)this.type).add("name", (Object)this.name).add("index", this.index).toString();
    }

    public static ImmutableParamEntry copyOf(ConsistentOverrides.ParamEntry instance) {
        if (instance instanceof ImmutableParamEntry) {
            return (ImmutableParamEntry)instance;
        }
        return ImmutableParamEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConsistentOverrides.ParamEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_INDEX = 4L;
        private long initBits = 7L;
        @Nullable
        private Type type;
        @Nullable
        private String name;
        private int index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ConsistentOverrides.ParamEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.name(instance.name());
            this.index(instance.index());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder index(int index) {
            this.index = index;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableParamEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableParamEntry(this.type, this.name, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build ParamEntry, some of required attributes are not set " + attributes;
        }
    }
}

