/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.io.Serializable;

@BugPattern(name="JUnit5RuleUsage", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Using Rule/ClassRules in Junit5 tests results in the rules silently not executing")
@AutoService(value={BugChecker.class})
public final class JUnit5RuleUsage
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String JUNIT4_RULE = "org.junit.Rule";
    private static final String JUNIT4_CLASS_RULE = "org.junit.ClassRule";
    private static final String JUNIT5_TEST_ANNOTATION = "org.junit.jupiter.api.Test";
    private static final String RULE_MIGRATION_SUPPORT = "org.junit.jupiter.migrationsupport.rules.EnableRuleMigrationSupport";
    private static final Matcher<ClassTree> hasMigrationSupport = Matchers.hasAnnotation((String)"org.junit.jupiter.migrationsupport.rules.EnableRuleMigrationSupport");
    static final Matcher<ClassTree> hasJunit5TestCases = Matchers.hasMethod((Matcher)Matchers.hasAnnotationOnAnyOverriddenMethod((String)"org.junit.jupiter.api.Test"));
    private static final Matcher<ClassTree> hasJunit4Rules = JUnit5RuleUsage.hasVariable((Matcher<VariableTree>)Matchers.anyOf((Matcher[])new Matcher[]{JUnit5RuleUsage.hasAnnotationOnVariable("org.junit.ClassRule"), JUnit5RuleUsage.hasAnnotationOnVariable("org.junit.Rule")}));

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!hasMigrationSupport.matches((Tree)tree, state) && hasJunit5TestCases.matches((Tree)tree, state) && hasJunit4Rules.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("Do not use Rule/ClassRule with junit-jupiter").build();
        }
        return Description.NO_MATCH;
    }

    static Matcher<ClassTree> hasVariable(Matcher<VariableTree> matcher) {
        return (Matcher & Serializable)(classTree, state) -> classTree.getMembers().stream().filter(tree -> tree instanceof VariableTree).anyMatch(tree -> matcher.matches((Tree)((VariableTree)tree), state));
    }

    static Matcher<VariableTree> hasAnnotationOnVariable(String annotation) {
        return (Matcher & Serializable)(variableTree, state) -> {
            Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)variableTree);
            return sym != null && ASTHelpers.hasAnnotation((Symbol)sym, (String)annotation, (VisitorState)state);
        };
    }
}

