/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.time.ZoneOffset;

@BugPattern(name="JavaTimeSystemDefaultTimeZone", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="The system default time zone should not be used, since the behavior is system dependent. Instead, UTC should always be used.")
@AutoService(value={BugChecker.class})
public final class JavaTimeSystemDefaultTimeZone
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> CLOCK_SYSTEM_DEFAULT_ZONE_MATCHER = Matchers.staticMethod().onClass("java.time.Clock").named("systemDefaultZone").withParameters(new String[0]);
    private static final Matcher<ExpressionTree> ZONE_ID_SYSTEM_DEFAULT_MATCHER = Matchers.staticMethod().onClass("java.time.ZoneId").named("systemDefault").withParameters(new String[0]);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (CLOCK_SYSTEM_DEFAULT_ZONE_MATCHER.matches((Tree)tree, state)) {
            return this.buildDescription(tree).addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"systemUTC", (VisitorState)state)).build();
        }
        if (ZONE_ID_SYSTEM_DEFAULT_MATCHER.matches((Tree)tree, state)) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            return this.buildDescription(tree).addFix((Fix)fix.replace((Tree)tree, SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)ZoneOffset.class.getName()) + ".UTC").build()).build();
        }
        return Description.NO_MATCH;
    }
}

