/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="LoggerEnclosingClass", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Loggers created using getLogger(Class<?>) must reference their enclosing class.")
@AutoService(value={BugChecker.class})
public final class LoggerEnclosingClass
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Matcher<VariableTree> matcher = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.isField(), Matchers.isSubtypeOf((String)"org.slf4j.Logger"), Matchers.variableInitializer((Matcher)MethodMatchers.staticMethod().onClass("org.slf4j.LoggerFactory").named("getLogger").withParameters(new String[]{Class.class.getName()}))}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.isField(), Matchers.isSubtypeOf((String)"com.palantir.logsafe.logger.SafeLogger"), Matchers.variableInitializer((Matcher)MethodMatchers.staticMethod().onClass("com.palantir.logsafe.logger.SafeLoggerFactory").named("get").withParameters(new String[]{Class.class.getName()}))})});

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (!matcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree getLoggerInvocation = (MethodInvocationTree)tree.getInitializer();
        ExpressionTree classArgument = getLoggerInvocation.getArguments().get(0);
        if (!(classArgument instanceof MemberSelectTree)) {
            return Description.NO_MATCH;
        }
        MemberSelectTree memberSelectTree = (MemberSelectTree)classArgument;
        if (!memberSelectTree.getIdentifier().contentEquals("class") || memberSelectTree.getExpression().getKind() != Tree.Kind.IDENTIFIER) {
            return Description.NO_MATCH;
        }
        Symbol targetSymbol = ASTHelpers.getSymbol((Tree)memberSelectTree.getExpression());
        Symbol.ClassSymbol enclosingClassSymbol = LoggerEnclosingClass.enclosingConcreteClass(ASTHelpers.enclosingClass((Symbol)ASTHelpers.getSymbol((VariableTree)tree)));
        if (targetSymbol == null || enclosingClassSymbol == null) {
            return Description.NO_MATCH;
        }
        if (state.getTypes().isSameType(targetSymbol.type, enclosingClassSymbol.type)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        return this.buildDescription(classArgument).addFix((Fix)fix.replace((Tree)classArgument, enclosingClassSymbol.name + ".class").build()).build();
    }

    private static Symbol.ClassSymbol enclosingConcreteClass(Symbol.ClassSymbol input) {
        Symbol.ClassSymbol current = input;
        while (current != null && current.isAnonymous()) {
            current = ASTHelpers.enclosingClass((Symbol)current);
        }
        return current;
    }
}

