/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.Set;

@BugPattern(name="LogsafeArgName", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Prevent certain argument names from being logged as safe.")
@AutoService(value={BugChecker.class})
public final class LogsafeArgName
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    static final String UNSAFE_ARG_NAMES_FLAG = "LogsafeArgName:UnsafeArgNames";
    private static final Matcher<ExpressionTree> SAFE_ARG_OF = Matchers.staticMethod().onClass("com.palantir.logsafe.SafeArg").named("of");
    private final Set<String> unsafeParamNames;

    public LogsafeArgName() {
        this.unsafeParamNames = ImmutableSet.of();
    }

    public LogsafeArgName(ErrorProneFlags flags) {
        this.unsafeParamNames = (Set)flags.getList(UNSAFE_ARG_NAMES_FLAG).map(ImmutableSet::copyOf).orElseGet(ImmutableSet::of);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (this.unsafeParamNames.isEmpty() || !SAFE_ARG_OF.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = tree.getArguments();
        ExpressionTree argNameExpression = args.get(0);
        if (argNameExpression instanceof JCTree.JCLiteral) {
            String argName = (String)((JCTree.JCLiteral)argNameExpression).getValue();
            if (this.unsafeParamNames.stream().anyMatch(unsafeArgName -> unsafeArgName.equalsIgnoreCase(argName))) {
                SuggestedFix.Builder builder = SuggestedFix.builder();
                String unsafeArg = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (String)"com.palantir.logsafe.UnsafeArg");
                return this.buildDescription(tree).setMessage("Arguments with name '" + argName + "' must be marked as unsafe.").addFix((Fix)builder.replace((Tree)tree.getMethodSelect(), unsafeArg + ".of").build()).build();
            }
        }
        return Description.NO_MATCH;
    }
}

