/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="ObjectsHashCodeUnnecessaryVarargs", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="java.util.Objects.hash(non-varargs) should be replaced with java.util.Objects.hashCode(value) to avoid unnecessary varargs array allocations.")
@AutoService(value={BugChecker.class})
public final class ObjectsHashCodeUnnecessaryVarargs
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> HASH_MATCHER = MethodMatchers.staticMethod().onClass("java.util.Objects").named("hash");
    private static final Matcher<ExpressionTree> ARRAY_MATCHER = Matchers.isArrayType();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree argument;
        if (HASH_MATCHER.matches((Tree)tree, state) && tree.getArguments().size() == 1 && !ARRAY_MATCHER.matches((Tree)(argument = tree.getArguments().get(0)), state)) {
            return this.buildDescription(tree).addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"hashCode", (VisitorState)state)).build();
        }
        return Description.NO_MATCH;
    }
}

