/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@BugPattern(name="PreferSafeLoggableExceptions", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Throw SafeLoggable exceptions to ensure the exception message will not be redacted")
@AutoService(value={BugChecker.class})
public final class PreferSafeLoggableExceptions
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final ImmutableMap<Class<?>, String> EXCEPTION_MAPPINGS = ImmutableMap.of(IllegalArgumentException.class, (Object)"SafeIllegalArgumentException", IllegalStateException.class, (Object)"SafeIllegalStateException", IOException.class, (Object)"SafeIoException", NullPointerException.class, (Object)"SafeNullPointerException", RuntimeException.class, (Object)"SafeRuntimeException");
    private static final Matcher<ExpressionTree> FAST_EXCEPTION_TYPE_CHECK = Matchers.anyOf((Iterable)EXCEPTION_MAPPINGS.keySet().stream().map(Matchers::isSameType).collect(Collectors.toList()));
    private final Matcher<ExpressionTree> compileTimeConstExpressionMatcher = new CompileTimeConstantExpressionMatcher();
    private static final Supplier<Type> JAVA_STRING = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.String"));

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!FAST_EXCEPTION_TYPE_CHECK.matches((Tree)tree.getIdentifier(), state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = tree.getArguments();
        Optional<ExpressionTree> messageArg = args.stream().filter(arg -> ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)arg), (Type)((Type)JAVA_STRING.get(state)), (VisitorState)state)).reduce((one, two) -> one);
        if (!messageArg.isPresent()) {
            return Description.NO_MATCH;
        }
        if (!this.compileTimeConstExpressionMatcher.matches((Tree)messageArg.get(), state)) {
            return Description.NO_MATCH;
        }
        if (TestCheckUtils.isTestCode(state)) {
            return Description.NO_MATCH;
        }
        return EXCEPTION_MAPPINGS.entrySet().stream().filter(entry -> Matchers.isSameType((Class)((Class)entry.getKey())).matches((Tree)tree.getIdentifier(), state)).map(entry -> this.buildDescription(tree).setMessage("Prefer " + (String)entry.getValue() + " from com.palantir.safe-logging:preconditions").addFix((Fix)SuggestedFix.builder().replace((Tree)tree.getIdentifier(), (String)entry.getValue()).addImport("com.palantir.logsafe.exceptions." + (String)entry.getValue()).build()).build()).findAny().orElseThrow(() -> new IllegalStateException("Expected to match a known replaceable exception type"));
    }
}

