/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.util.List;

@BugPattern(name="ReadReturnValueIgnored", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="The result of a read call must be checked to know if EOF has been reached or the expected number of bytes have been consumed.")
@AutoService(value={BugChecker.class})
public final class ReadReturnValueIgnored
extends AbstractReturnValueIgnored {
    private static final Matcher<ExpressionTree> INPUT_STREAM_BUFFER_READ_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf(InputStream.class.getName()).named("read"), Matchers.not((Matcher)MethodMatchers.instanceMethod().onDescendantOf(InputStream.class.getName()).named("read").withParameters(new String[0]))});
    private static final Matcher<ExpressionTree> RAF_BUFFER_READ_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf(RandomAccessFile.class.getName()).named("read"), Matchers.not((Matcher)MethodMatchers.instanceMethod().onDescendantOf(RandomAccessFile.class.getName()).named("read").withParameters(new String[0]))});
    private static final Matcher<ExpressionTree> READER_SKIP_MATCHER = MethodMatchers.instanceMethod().onDescendantOf(Reader.class.getName()).named("skip").withParameters(new String[]{Long.TYPE.getName()});
    private static final Matcher<ExpressionTree> INPUT_STREAM_SKIP_MATCHER = MethodMatchers.instanceMethod().onDescendantOf(InputStream.class.getName()).named("skip").withParameters(new String[]{Long.TYPE.getName()});
    private static final Matcher<ExpressionTree> RAF_SKIP_MATCHER = MethodMatchers.instanceMethod().onDescendantOf(RandomAccessFile.class.getName()).named("skipBytes").withParameters(new String[]{Integer.TYPE.getName()});
    private static final Matcher<ExpressionTree> MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{RandomAccessFile.class.getName(), Reader.class.getName(), InputStream.class.getName()}).named("read"), INPUT_STREAM_SKIP_MATCHER, RAF_SKIP_MATCHER, READER_SKIP_MATCHER});

    public Matcher<? super ExpressionTree> specializedMatcher() {
        return MATCHER;
    }

    public Description describeReturnValueIgnored(MethodInvocationTree methodInvocationTree, VisitorState state) {
        Description result = super.describeReturnValueIgnored(methodInvocationTree, state);
        if (Description.NO_MATCH.equals(result)) {
            return result;
        }
        if (INPUT_STREAM_BUFFER_READ_MATCHER.matches((Tree)methodInvocationTree, state)) {
            return this.buildDescription(methodInvocationTree).addFix((Fix)ReadReturnValueIgnored.replaceWithStatic(methodInvocationTree, state, ByteStreams.class.getName() + ".readFully")).build();
        }
        if (INPUT_STREAM_SKIP_MATCHER.matches((Tree)methodInvocationTree, state)) {
            return this.buildDescription(methodInvocationTree).addFix((Fix)ReadReturnValueIgnored.replaceWithStatic(methodInvocationTree, state, ByteStreams.class.getName() + ".skipFully")).build();
        }
        if (RAF_BUFFER_READ_MATCHER.matches((Tree)methodInvocationTree, state)) {
            return this.buildDescription(methodInvocationTree).addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)methodInvocationTree, (String)"readFully", (VisitorState)state)).build();
        }
        if (READER_SKIP_MATCHER.matches((Tree)methodInvocationTree, state)) {
            return this.buildDescription(methodInvocationTree).addFix((Fix)ReadReturnValueIgnored.replaceWithStatic(methodInvocationTree, state, CharStreams.class.getName() + ".skipFully")).build();
        }
        return this.describeMatch(methodInvocationTree);
    }

    private static SuggestedFix replaceWithStatic(MethodInvocationTree tree, VisitorState state, String fullyQualifiedReplacement) {
        ExpressionTree methodSelect = tree.getMethodSelect();
        if (!(methodSelect instanceof MemberSelectTree)) {
            return SuggestedFix.emptyFix();
        }
        CharSequence sourceCode = state.getSourceCode();
        if (sourceCode == null) {
            return SuggestedFix.emptyFix();
        }
        MemberSelectTree memberSelectTree = (MemberSelectTree)methodSelect;
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String qualifiedReference = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)fullyQualifiedReplacement);
        CharSequence args = sourceCode.subSequence(state.getEndPosition((Tree)methodSelect) + 1, state.getEndPosition((Tree)ReadReturnValueIgnored.lastItem(tree.getArguments())));
        fix.replace((Tree)tree, qualifiedReference + '(' + state.getSourceForNode((Tree)memberSelectTree.getExpression()) + ", " + args + ')');
        return fix.build();
    }

    private static <T> T lastItem(List<T> items) {
        Preconditions.checkState((!items.isEmpty() ? 1 : 0) != 0, (Object)"List must not be empty");
        return items.get(items.size() - 1);
    }
}

