/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

final class TestCheckUtils {
    private static final Matcher<ClassTree> hasJUnit5TestCases = Matchers.hasMethod((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotationOnAnyOverriddenMethod((String)"org.junit.jupiter.api.Test"), Matchers.hasAnnotationOnAnyOverriddenMethod((String)"org.junit.jupiter.api.TestTemplate")}));
    private static final Matcher<ClassTree> hasTestCases = Matchers.anyOf((Matcher[])new Matcher[]{JUnitMatchers.hasJUnit4TestCases, hasJUnit5TestCases});

    private TestCheckUtils() {
    }

    static boolean isTestCode(VisitorState state) {
        TreePath path = state.getPath();
        for (Tree ancestor : path) {
            if (!(ancestor instanceof ClassTree) || !hasTestCases.matches((Tree)((ClassTree)ancestor), state)) continue;
            return true;
        }
        return state.getPath().getCompilationUnit().getImports().stream().map(ImportTree::getQualifiedIdentifier).map(Object::toString).anyMatch(TestCheckUtils::isTestImport);
    }

    private static boolean isTestImport(String qualifiedName) {
        return qualifiedName.startsWith("org.junit.") || qualifiedName.startsWith("junit.") || qualifiedName.startsWith("org.mockito.") || qualifiedName.startsWith("org.assertj.");
    }
}

